
/*
 * fe_database.h:
 *      header file for fe_database.cpp.
 *
 *@@changed V0.9.0 (99-10-31) [umoeller]: renamed from database.h
 *@@include #include "frontend\fe_base.h"
 */

/*
 *      Copyright (C) 1999-2002 Ulrich Mller.
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation, in version 2 as it comes in the COPYING
 *      file of this distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef WARPIN_FEDATABASE_HEADER_INCLUDED
    #define WARPIN_FEDATABASE_HEADER_INCLUDED

    /* ******************************************************************
     *
     *  Forward declarations
     *
     ********************************************************************/

    class FEDBPackage;
    class FEPackageID;
    class BSConfigSys;
    class FEDatabaseStatus;

    // INI keys in database
    #define WPIKEY_FILESLIST        "Files"
    #define WPIKEY_TARGETPATH       "TargetPath"
    #define WPIKEY_REQUIRES         "Requires"
    #define WPIKEY_CONFIGATTRS      "ConfigSysAttrs"
    #define WPIKEY_CONFIGDONE       "ConfigSysDone"
    #define WPIKEY_REGISTERATTRS    "RegisterAttrs"
    #define WPIKEY_REGISTERDONE     "RegisterDone"
    #define WPIKEY_REPLACEATTRS     "ReplaceAttrs"
    #define WPIKEY_REPLACEDONE      "ReplaceDone"
    #define WPIKEY_WPSOBJECTATTRS   "WPSObjectAttrs"
    #define WPIKEY_WPSOBJECTDONE    "WPSObjectDone"
    #define WPIKEY_CLEARPRFATTRS    "ClearPrfAttrs"  // added V0.9.1 (2000-02-07) [umoeller]
    #define WPIKEY_WRITEPRFATTRS    "WritePrfAttrs"  // added V0.9.1 (2000-02-07) [umoeller]
    #define WPIKEY_WRITEPRFDONE     "WritePrfDone"   // added V0.9.1 (2000-02-07) [umoeller]
    #define WPIKEY_EXECUTEATTRS     "ExecuteAttrs"   // added V0.9.1 (2000-02-03) [umoeller]
    #define WPIKEY_EXECUTEDONE      "ExecuteDone"    // added V0.9.1 (2000-02-03) [umoeller]
    #define WPIKEY_DEEXECUTEATTRS   "DeExecuteAttrs" // added V0.9.9 (2001-03-27) [umoeller]
    #define WPIKEY_DEEXECUTERESOLVED "DeExecuteResolved" // added V0.9.9 (2001-03-27) [umoeller]
    #define WPIKEY_KILLPROCESSATTRS "KillProcessAttrs" // added V0.9.1 (2000-02-12) [umoeller]
    #define WPIKEY_WIPACKHEADER     "WIPackHeader"
    #define WPIKEY_INSTALLDATETIME  "InstallDateTime"
    #define WPIKEY_DESCRIPTION      "Description"   // added V0.9.2 (2000-03-10) [umoeller]
    #define WPIKEY_CODEPAGE         "Codepage"      // added V0.9.2 (2000-03-10) [umoeller]
    #define WPIKEY_DIRSCREATED      "DirsCreated"   // added V0.9.20 (2002-07-22) [umoeller]
    #define WPIKEY_INSTALLEDUSING   "InstalledUsing"    // added V0.9.20 (2002-07-22) [umoeller]

    /*
     *@@ FEDatabaseExcpt:
     *      exception thrown by the database when
     *      it appears to be corrupt.
     *
     *@@added V0.9.1 (2000-01-08) [umoeller]
     */

    /* class FEDatabaseExcpt : public BSExcptBase
    {
        public:
            BOOL        _fRecover;
            ustring     _ustrFailingPckID;

            FEDatabaseExcpt(FELocals &Locals,
                            ULONG ulErrNo,
                            const ustring *pustrPckID,
                            BOOL fRecover,
                            ustring *paStrings = NULL,
                            ULONG ulTable = 0);
            FEDatabaseExcpt(const ustring *pustrPckID,
                            const ustring &ustrErrMsg,
                            BOOL fRecover);
    }; */

    /* ******************************************************************
     *
     *  FEDatabase declaration
     *
     ********************************************************************/

    // database callback codes (ulReportCode)
    #define DBC_NEXTPACKAGE                 1
    #define DBC_NEXTFILE                    2

    #define DBC_FILEERROR                   3
    #define DBC_EXISTINGFILENEWER           4
    #define DBC_EXISTINGFILEOLDER           5
    #define DBC_DELETEERROR                 6
    // #define DBC_DELETEDIRERROR              7    removed V0.9.19 (2002-04-14) [umoeller]
    #define DBC_PACKAGEREMOVED              8
    #define DBC_TARGETDIRNOTFOUND           9
    // #define DBC_CLASSDEREGISTERED           10
    // #define DBC_DEREGISTERCLASSERROR        11
    // #define DBC_CLASSUNREPLACED             12
    // #define DBC_UNREPLACECLASSERROR         13
    // #define DBC_OBJECTDELETED               14
    // #define DBC_OBJECTDELETEERROR           15
    // #define DBC_CFGSYSUNDONE                16
    // #define DBC_UNDOCFGSYSERROR             17
    // #define DBC_PROFILECLEARED              18  // V0.9.5 (2000-08-26) [umoeller]
    // #define DBC_CLEARPROFILEERROR           19  // V0.9.5 (2000-08-26) [umoeller]

    #define DBC_FILELOCKED                  20  // V0.9.4 (2000-07-01) [umoeller]

    // #define DBC_DEEXECUTING                 21  // V0.9.9 (2001-03-30) [umoeller]
    // #define DBC_DEEXECUTE_DONE              22  // V0.9.9 (2001-03-30) [umoeller]
    // #define DBC_DEEXECUTE_ERROR             23  // V0.9.9 (2001-03-30) [umoeller]

    #define DBC_DELETE_EXISTINGFILENEWER    24  // V0.9.9 (2001-04-06) [umoeller]

    /*
    typedef ULONG APIENTRY FNDATABASECALLBACK(ULONG ulReportCode,
                                              FEDatabaseStatus &Status,
                                              ULONG ulExtra);
    typedef FNDATABASECALLBACK *PFNDATABASECALLBACK;
    */

    #define DBT_VERIFY          1
    #define DBT_DEINSTALL       2

    #define DBT_DELETEFILES     0x01
    #define DBT_UNDOCONFIG      0x02

    /*
     *@@ FEDatabaseStatus:
     *      structure stored in GUIDatabaseThread
     *      which gets updated while the database thread
     *      is running. A pointer to this structure is
     *      always passed to guiDatabaseCallback so
     *      the GUI knows what's going on.
     *
     *@@added V0.9.0 (99-11-02) [umoeller]
     *@@changed V0.9.14 (2001-07-26) [umoeller]: renamed from GUIDatabaseThreadStatus
     */

    class FEDatabaseStatus : public BSRoot
    {
        public:
            DECLARE_CLASS(FEDatabaseStatus);

            FELocals            &_Locals;

            ULONG               _cPackages;
                            // packages count (in list), initialized by DB thread

            ULONG               _cFiles;
                            // total files count (all packages)

            ULONG               _ulCurrentPackage;
                            // package being worked on
                            // (updated while DB thread is working)

            ULONG               _ulCurrentFile;
                            // total file index being worked on
                            // (updated while DB thread is working)

            FEDBPackage         *_pPackage;
                            // current package

            WIFileHeader        *_pwifh;
                            // current file (back-end file header)

            /* ULONG               _cDirsInDir,
                                _cFilesInDir; */
                            // with DBC_DELETEDIRERROR, this tells the
                            // number of directories and files which
                            // are left in a directory that cannot be
                            // deleted
                            // removed V0.9.19 (2002-04-14) [umoeller]

            // PFNDATABASECALLBACK _pfnDatabaseCallback;
            // ULONG               _ulUser;

            virtual ULONG Callback(ULONG ulReportCode,
                                   ULONG ulExtra) = 0;

            virtual void OnObjectDeleted(BSDeleteWPSObject *pCfg,
                                         BOOL fSuccess) = 0;

            virtual void OnClassUnreplaced(BSUnreplaceClass *pCfg,
                                           BOOL fSuccess) = 0;

            virtual void OnClassDeregistered(BSDeregisterClass *pCfg,
                                             BOOL fSuccess) = 0;

            virtual void OnCfgSysUndone(BSCfgSysManip *pCfg,
                                        BOOL fSuccess) = 0;

            virtual void OnProfileCleared(BSClearProfile *pCfg,
                                          BOOL fSuccess) = 0;

            virtual void OnDeExecute(BSDeExecute *pCfg,
                                     int iCode) = 0;

            virtual void OnCannotDeleteDirError(const ustring &ustrDirectory,
                                                ULONG cDirsInDir,
                                                ULONG cFilesInDir) = 0;

            /*
             *@@ FEDatabaseStatus:
             *      default constructor. Sets all fields to 0.
             */

            FEDatabaseStatus(FELocals &Locals)
                :   BSRoot(tFEDatabaseStatus),
                    _Locals(Locals)
            {
                _cPackages = 0;
                _cFiles = 0;
                _ulCurrentPackage = 0;
                _ulCurrentFile = 0;
                _pPackage = 0;
                _pwifh = 0;
            }
    };

    /*
     *@@ FEDatabase:
     *      the database class.
     *
     *      See @class_rels for an overview of how the front-end
     *      classes interact.
     *
     *@@changed V0.9.18 (2002-03-03) [umoeller]: greatly optimized db packages handling for speed
     */

    class FEDatabase : public BSRoot
    {
        public:
            DECLARE_CLASS(FEDatabase);

        // allow only FEPackage class to access our private members
        friend class FEDBPackage;
        friend class FEInstallJob;

        private:
            ULONG               _hmtxOneInstance;
                        // moved this here V0.9.18 (2002-03-08) [umoeller]

            // profile handle of DATABASE.INI (opened by constructor)
            HINI                _hiniDatabase;
            string              _strDatabaseFile; // V0.9.14 (2001-08-09) [umoeller]
            FELocals            &_Locals;

            list<string*>       _PackageIDsList;    // list of package IDs in databse
                                                    // V0.9.18 (2002-03-03) [umoeller]

        public:
            const string *EnumPackages(const string *pstrPackageIDSearch)
                 const;

            // list of all packages in the Global Database;
            list<FEDBPackage*>  _DBPackagesList;

            FEDatabase(FELocals &Locals,
                       const ustring &ustrDatabasePath);

            ~FEDatabase();

            const string& QueryDatabaseFile() const;

            /* FEPackageID* FindPackageID(const char *pcszAuthor,
                                       const char *pcszApplication,
                                       const char *pcszPackageName)
                         const; */
                // removed V0.9.18 (2002-03-03) [umoeller]

            const FEDBPackage* FindDBPackage(const ustring &ustrAuthor,
                                             const ustring &ustrApplication,
                                             const ustring &ustrPackageName)
                               const;

            const FEDBPackage* FindDBPackage(const FEPackageID &PckID)
                               const;

            ULONG IsPackageRequired(FEPackageID& PckIDThis,
                                    list<FEDBPackage*> &RequiredByList,
                                    list<FEDBPackage*> *pIgnoreList)
                  const;

            BOOL RemovePackage(const FEDBPackage *pPackage);

            VOID UndoConfig(HAB hab,
                            FEDatabaseStatus &Status,
                            BSConfigSys *pConfigSys,
                            PBOOL pfConfigSysChanged);

            BOOL VerifyFile(FEDatabaseStatus &Status);

            BOOL DeinstallFile(FEDatabaseStatus &Status);

            VOID DeinstallOrVerify(HAB hab,
                                   FEDatabaseStatus &Status,
                                   list<FEDBPackage*> &PackagesList,
                                   ULONG ulTask,
                                   ULONG flDeinstall);
    };

#endif
