wmChar: wParam with: lParam
    "Private - Processes WM_CHAR messages."
  | result text |

  "Extract the character from WPARAM and put it in LastKey."
  (result := super wmChar: wParam with: lParam) == nil
    ifFalse: [
      LastKey > 16rFF ifTrue: [super peekChar].
      ^result].

  "If the receiver is running on a double byte platform,
  disable certain control key combinations because they
  interfere with the character count."
  OSWidget isDBPlatform ifTrue: [
    (OS getKeyState: VkControl) < 0 ifTrue: [
      LastKey == VkBack ifTrue: [^0].  "Ctrl+Bs"
      LastKey == Lf value ifTrue: [^0].  "Ctrl+Enter"
      LastKey == VkTab ifTrue: [^0].  "Ctrl+Tab"
      LastKey == VkReturn ifTrue: [^0].  "Ctrl+Enter"
      LastKey == $h value ifTrue: [self adjustBackspace].  "Ctrl+h"
      LastKey == $v value ifTrue: [self paste.  ^0].  "Ctrl+V"
      LastKey == $x value ifTrue: [self cut.  ^0].  "Ctrl+X"
      LastKey == $z value ifTrue: [^0].  "Ctrl+Z"
      LastKey == Del value  ifTrue: [^0]]].  "Ctrl+Del"

  "Process the OSxActivate event."
  LastKey == VkReturn ifTrue: [
    (self hooksActivate and: [self isSingleLine or: [self isAligned]])
      ifTrue: [self postEvent: OSxActivate.  ^0].
    self isAligned ifTrue: [^0]].

  "Bug in Windows.  When the receiver is a single-line
  text widget, when the user presses return or escape,
  Windows beeps.  The fix is to look for VK_RETURN
  and VK_ESCAPE and not call the text window proc."
  (self isSingleLine or: [self isAligned]) ifTrue: [
    LastKey == VkReturn ifTrue: [^0].
    (parent isComboBox and: [parent isDropped])
      ifFalse: [LastKey == VkEscape ifTrue: [^0]]].

  "Process the OSxVerify event."
  self hooksVerify ifTrue: [
    (LastKey == VkReturn and: [self isSingleLine]) ifTrue: [^result].
    (self verifyCharacter: LastAscii asCharacter) ifTrue: [
      LastKey > 16rFF ifTrue: [super peekChar].  ^0]].

  "If we are on a double byte platform, adjust the encoding and
  update the character count based on the character that was
  typed."
  self readOnly ifFalse: [
    OSWidget isDBPlatform ifTrue: [
      text := LastAscii asCharacter asString.
      self updateEncoding: text.
                                                     
      self isEncoded ifTrue: [
     LastKey == VkBack
       ifTrue: [self adjustBackspace]
       ifFalse: [
         (LastKey == VkTab or: [LastKey == VkReturn or: [LastAscii >= 16r20]])
           ifTrue: [result := self adjustCharacter: LastAscii asCharacter]]]]].

  "Check if the OSxActivate event was sent."
  result == 0 ifTrue: [LastKey > 16rFF ifTrue: [super peekChar]].
  ^result
