// HelloOS2.Cpp, a Hello application for OS/2 Developer
// From an article by Lou Miranda

// define the section(s) you want to include from os2.h
#define INCL_WIN
// the main OS/2 header file
#include <os2.h>


int main (void);
// use extern"C" if you're using C++
extern "C" {
MRESULT EXPENTRY ClientWndProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
}

int main( void)
{
	HAB hab;	// an anchor block; used only for retrieving error information
	HMQ hmq;	// a message queue--where you get your application's messages
	QMSG qmsg;
	HWND hwndFrame,	// the frame window (equivalent to the Windows "non-client"
		hwndClient;	// the client window--where you do your drawing
	// set your frame window's flags; note that we remove the menu, icon, and
	//		accelerator table flags, because if they are included then these
	//		resources **must** be defined in the RC file, which we don't have
	ULONG flFrameFlags =  FCF_STANDARD & ~FCF_MENU & ~FCF_ICON & ~FCF_ACCELTABLE ;
	CHAR szClassName[] = "HelloOS2" ;
	CHAR szWindowTitle[] = "Hello, OS/2 Developer" ;

	hab = WinInitialize (0);	// initialize OS/2's windowing
	hmq = WinCreateMsgQueue (hab, 0L);	// create a default-sized message queue

	// register your window class for the client window
	WinRegisterClass (hab, szClassName,	ClientWndProc, CS_SIZEREDRAW, 0);

	// create a "standard" window, which is a frame window plus your client
	hwndFrame = WinCreateStdWindow (HWND_DESKTOP, 0L, &flFrameFlags, szClassName,
				   szWindowTitle, 0L, NULLHANDLE, 0L, &hwndClient);

	// display the window
	WinSetWindowPos (hwndFrame, HWND_TOP, 0, 0, 0, 0,
			SWP_SHOW | SWP_ACTIVATE | SWP_ZORDER);

	// start processing the messages for your main window
	while (WinGetMsg (hab, &qmsg, NULLHANDLE, 0L, 0L))
		WinDispatchMsg (hab, &qmsg);

	WinDestroyWindow (hwndFrame);	// destroy your main window
	WinDestroyMsgQueue (hmq);	// destroy the message queue
	WinTerminate (hab);		// terminate the use of OS/2's windowing

	return 0L;
}

// your client window procedure
MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
	HPS		hps;	// a handle to a Presentation Space--what you draw into
	RECTL	rectL;	// the drawing rectangle

	switch (msg)
	{
		// paint your client window
		case WM_PAINT:
			hps = WinBeginPaint (hwnd, NULLHANDLE, &rectL);
			WinQueryWindowRect (hwnd, &rectL);
			WinFillRect (hps, &rectL, SYSCLR_WINDOW);
			WinDrawText (hps, -1, "OS/2 Hello for OS/2 Developer!", &rectL,
				SYSCLR_WINDOWTEXT, SYSCLR_WINDOW, DT_CENTER | DT_VCENTER);
			WinEndPaint (hps);
			return (MRESULT) 0;

		default:
            break;
	}
	// let OS/2 handle any message you didn't process
	return WinDefWindowProc (hwnd, msg, mp1, mp2);
}

