// Windows Hello for OS/2 Developer: Bare-bones Hello program for MS Windows



#include <windows.h>		// include the main Windows header file

// declare your window procedure
LRESULT PASCAL WndProc (HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// declare your main procedure
int PASCAL WinMain(HINSTANCE hCurInstance, HINSTANCE hPrevInstance,
		LPSTR /* lpCmdLine */, int nCmdShow)
{
	static char appName[] = "HelloWin";
	HWND hWnd;
	MSG msg;
	WNDCLASS wndclass;

	if (!hPrevInstance)
	{
		// create & register your window class, with the desired attributes
		wndclass.style			= CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc	= WndProc;
		wndclass.cbClsExtra 	= 0;
		wndclass.cbWndExtra	= 0;
		wndclass.hInstance	= hCurInstance;
		wndclass.hIcon			= LoadIcon (NULL, IDI_APPLICATION);
		wndclass.hCursor		= LoadCursor (NULL, IDC_ARROW);
		wndclass.hbrBackground	= GetStockObject (WHITE_BRUSH);
		wndclass.lpszMenuName	= NULL;
		wndclass.lpszClassName	= appName;

		RegisterClass (&wndclass);
	}

	// create the main window
	hWnd = CreateWindow (appName,
								"Hello, OS/2 Developer",
								WS_OVERLAPPEDWINDOW,
								CW_USEDEFAULT,
								CW_USEDEFAULT,
								CW_USEDEFAULT,
								CW_USEDEFAULT,
								NULL,
								NULL,
								hCurInstance,
								NULL);

	// display the main window
	ShowWindow (hWnd, nCmdShow);
	UpdateWindow (hWnd);

	// start processing the messages sent to you in the message queue
	while (GetMessage (&msg, NULL, 0, 0))
	{
		TranslateMessage (&msg);
		DispatchMessage (&msg);
	}
	return (msg.wParam);
}


// your window procedure for the main window
LRESULT PASCAL WndProc (HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	HDC hDC;
	PAINTSTRUCT paintStruct;
	RECT rect;

	switch (uMsg)
	{
		// paint (draw) the main window
		case WM_PAINT:
			hDC = BeginPaint (hWnd, &paintStruct);
			GetClientRect (hWnd, &rect);
			DrawText (hDC, "Windows Hello for OS/2 Developer!", -1, &rect,
						DT_SINGLELINE | DT_CENTER | DT_VCENTER);
			EndPaint (hWnd, &paintStruct);
			return (0);

		// exit the application
		case WM_DESTROY:
			PostQuitMessage (0);
			return (0);
	}

	// if you don't process the message, let Windows take care of it
	return DefWindowProc (hWnd, uMsg, wParam, lParam);
}

