/* ********************************************************************** */
/*                                                                        */
/*    Readme.h                                                            */
/*                                                                        */
/*                                                                        */
/* ********************************************************************** */

const char  acAboutBuffer[] =
"\n\n    This program was written as a source code sample to accompany an"
" article I wrote for the November 1994 issue of _OS/2 Devloper_"
" magazine. The article discusses OS/2's color palette management APIs;"
" ViewBMP was written as a demonstration of those APIs and their"
" capabilities.\n"
" \n"
" FEATURES\n"
" \n"
"    ViewBMP displays bitmaps, which are loaded from files. Although"
" I haven't thoroughly tested it with every possible format, it"
" should handle most single-image OS/2 1.x, OS/2 2.x, and"
" Windows bitmaps.  It will handle most color depths, including"
" 24-bit, and will handle compressed formats (e.g. Huffman 1-D, 4-bit"
" RLE, 8-bit RLE, etc). One key feature of ViewBMP is that it"
" can load and display the bitmaps using either the system default"
" color palette or using the custom color palette which is stored in"
" the bitmap. The latter provides the best display results but requires the"
" use of the OS/2 color palette management system; note that this option (and the"
" menu item that selects it) will be disabled on systems that do not"
" support color palettes.\n"
" \n"
"    The bitmap file to be displayed may be selected not only from the"
" standard Open File Dialog, but also by entering the file name on the"
" command line. One benefit of this feature is that ViewBMP may be"
" associated with .BMP file extensions, and automatically invoked by"
" opening a .BMP file.\n"
" \n"
"    It is important to note that ViewBMP was intended as an educational"
" source code sample first, and as a bitmap viewing utility second."
" Priority was given to source code simplicity and clarity. As such,"
" many features (and most of the error checking) which would make ViewBMP a"
" robust, production-level image application have been left out. If"
" you are looking for a serious OS/2 image viewing application, I would"
" highly recommend two shareware programs: PMJPEG and Galleria. Both"
" support multiple image formats (e.g. BMP, GIF, JPEG, PCX, etc), image"
" format conversions, image manipulation, and tons of other features."
" Both are very reasonably priced. And although both do a terrific job,"
" my personal favorite is PMJPEG.\n"
" \n"
" SOURCE CODE\n"
" \n"
"    Source code (and all necessary resources) should have accompanied"
" this executable program; if not, you may request it from me at the"
" E-mail address listed below. The code is provided free of charge."
" The code was developed to demonstrate how an application would"
" take advantage of OS/2 color palettes. It also allows for a comparison of"
" the results (i.e. an image may be view both with and without color"
" palettes ). The code demonstrates many techniques, including:\n"
" \n"
   " * How to read in and decode a single image bitmap file\n"
" \n"
   " * How to extract color info from a bitmap file\n"
" \n"
   " * How to create a color palette\n"
" \n"
   " * How to select a color palette into multiple Presentation Spaces\n"
" \n"
   " * How to create a memory bitmap maintaining original color"
" integrity\n"
" \n"
   " * How to realize a color palette to maintain proper bitmap colors when"
" drawing to the screen\n"
" \n"
   " * How to properly respond to WM_REALIZEPALETTE messages\n"
" \n"
   " * How to dispose of color palette and bitmap resources\n"
" \n"
   " * How to reset the system default color palette\n"
" \n"
"     The source code is relatively well commented and explains the"
" techniques used. It was intended to be easily understood, and"
" hopefully achieves that goal.\n"
" \n"
" WARRANTY ( unfortunate legality )\n"
" \n"
"    This application, and the associated source code, is provided to you"
" solely for the purpose of assisting you in the development of your"
" applications.  Both application and code are provided \"AS IS\", without warranty of any"
" kind.  The author shall not be liable for any damages arising out of"
" your use of the application and/or source code, even if he has"
" been advised of the possibility of such damages.\n"
" \n"
" SUPPORT\n"
" \n"
" As I said above, this program (and source) are provided on an \"AS IS\""
" basis.  I do not plan on updating or improving this program. But with the"
" source code, you should be able to add (or fix) anything"
" you like. Please feel free to incorporate the techniques demonstrated"
" (and portions of the code) in any application you are writing;"
" however I would ask that you make *significant* modifications to the"
" code if you are going to sell it.\n"
" \n"
" I will try to respond to all comments and questions sent to my E-mail"
" address below, but I can not guarantee that I will have timely"
" or complete answers. Thanks for your interest and your time. I hope"
" you find this sample application of value.\n"
" \n"
" John D. Webb\n"
" CompuServe: 71075,1117\n"
" Internet: 71075.1117@compuserve.com"
;
