//===============================================================
// vglcnv.h GL Canvas C++ class .h file - OS/2
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#ifndef VGLCNV_H
#define VGLCNV_H

#include <v/vcanvas.h>

extern "C"
{
  // OpenGL stuff here
  #define OS2  // needed for Borland to work with IBM gl.h
  #include <GL/gl.h>
  #include <GL/glu.h>
  #include <GL/pgl.h>
}

  const unsigned int vGL_Default = 0;
  const unsigned int vGL_RGB = 0x0001;   // RGBA is used (with alpha)
  const unsigned int vGL_Alpha = 0x0002; // if Alpha is set, RGBA is used
  const unsigned int vGL_Indexed = 0x0004;
  const unsigned int vGL_DoubleBuffer = 0x0008;
  const unsigned int vGL_Stereo = 0x0010;
  const unsigned int vGL_Stencil = 0x0020;
  const unsigned int vGL_Accum = 0x0040;
  const unsigned int vGL_Depth = 0x0080;

  class vWindow;		// we are part of a window

  class vBaseGLCanvasPane : public vCanvasPane
  {
    public:  //---------------------------------------- public
      vBaseGLCanvasPane(unsigned int vGLmode = vGL_Default, PaneType pt = P_Canvas);
      virtual ~vBaseGLCanvasPane();

      // Expose/redraw event
      virtual void Resize(int newW, int newH);  // Resize event

      // OpenGL specific stuff
      virtual void graphicsInit(void);
      void vglMakeCurrent(void);
      virtual void vglFlush();

      // Platform dependent
    protected:  //--------------------------------------- protected

      virtual void initialize(vWindow* pWindow, HWND pWidget);

      // Drawing and OpenGL for OS/2
      HAB      _hab;	   // app anchor block
      HPS      _hDC;	   // presentation space (not needed for direct OpenGL)
      PVISUALCONFIG _pVisualConfig;  // OpenGL visual config
      HGC    _hGLRC;       // OpenGL context
      HPAL     _hPalette;  // Palette

    private:  //--------------------------------------- private

      // OpenGL initialization of the drawings
      void _setUpPixelFormat();
      void _setUpPalette();

      // OpenGL info
      static int _pixelFormat;
      static int _doubleBuffer;  // if we have double buffering
      static unsigned int _vGLmode;
  };

#endif
