/*
	This program is provided on an "as is" basis, without warranty of any
	kind. The entire risk as to the quality and performance of the program
	is borne by you.

    Report bugs to: july@cblink.net
*/

%{
#include <stdio.h>
#include <string.h>
#include "v2i.h"
#define YYDEBUG 1

int colors, curcolor, curelem, cnt;
byte rgb[3];

void yyerror( char *s )
{
    printf( "Parse error!\n" );
}

void readval( long v )
{
	rgbquad q;

    if( curcolor <= colors )
    {
    	rgb[curelem++] = v;
        if( curelem == 3 )
        {
         	curelem = 0;
    		q.b = rgb[2];
            q.g = rgb[1];
            q.r = rgb[0];
            q.res = 0;
			icn->colortable[curcolor++] = nearest( q );
        }
    }
	else
	{
		PICT( cnt / icn->width, cnt % icn->width ) = icn->colortable[v];
		cnt++;
    }
}

%}

/* --------------------------------------------------------------- bison decl */

%union
{
    long value;
    char *cp;
}

%token          VBM1
%token          VBM8
%token          DEFINE
%token          UNSIGNED
%token          STATIC
%token          CHAR

%token <value>  CONST
%token <cp>     IDENT


%%
file
        : VBM1 {
            icn->depth = 1;
            /* */
            printf( "Only 256 color .VBM images are supported.\n" );
            YYABORT;
        } vbm1
        | VBM8 { icn->depth = 8; } vbm8
;

vbm1
        : /* empty */
        | vbm1 stat
        | vbm1 bitarray
;

vbm8
        : /* empty */
        | vbm8 stat
        | vbm8 {
            if( icn->width == 0 || icn->height == 0 )
            {
                printf( "Both `width' and `height' values must be specified!\n" );
                YYABORT;
            }
        } rgbarray
;

bitarray
		: STATIC
        | UNSIGNED
		| CHAR IDENT '[' ']' '=' '{' clist '}' ';'
;

rgbarray
		: STATIC
        | UNSIGNED
		| CHAR IDENT '[' ']' '=' '{'
        	CONST ',' {
            	colors = $7; curcolor = curelem = 0; cnt = 0;
            }
        	rgblist
        '}' ';'
;

rgblist
		: CONST { readval( $1 ); }
        | rgblist ',' CONST { readval( $3 ); }
;

stat
        : '#' DEFINE IDENT CONST '\n' {

			if( strstr( $3, "_depth" ) != 0 )
            {
                switch( $4 )
				{
					case 1: case 8:
                         if( $4 == icn->depth ) break;
					default:
                         printf( "Illegal 'depth' value "
                                 "(must be 1 or 8 and must be equal"
                                 " to the //vbmXXX line).\n" );
                         YYABORT;
				}
            }
            else if( strstr( $3, "_width" ) != 0 )
            {
            	switch( $4 )
				{
                    case 16: case 32: case 48: case 64:
                         if( icn->height != 0 && $4 != icn->height )
                         {
                            printf( "The 'width' value must be equal to the "
                                    "'height' value.\n" );
                            YYABORT;
                         }
                    	icn->width = $4;
                        break;
					default:
                         printf( "Illegal 'width' value "
                                 "(must be 16, 32, 48 or 64).\n" );
                         YYABORT;
				}
            }
            else if( strstr( $3, "_height" ) != 0 )
            {
            	switch( $4 )
				{
                    case 16: case 32: case 48: case 64:
                         if( icn->width != 0 && $4 != icn->width )
                         {
                            printf( "The 'height' value must be equal to the "
                                    " 'width' value.\n" );
                            YYABORT;
                         }
                    	icn->height = $4;
                        break;
					default:
                         printf( "Illegal 'height' value"
                                 "(must be 16, 32, 48 or 64).\n" );
                         YYABORT;
				}
            }
            free( $3 );
        }
;

clist
        : CONST {
			;
        }
        | clist ',' CONST
;


