/* REXX */
/*********************************************************************
* This exec sets the extended attributes of files to prdefined
* values by file extension.  Stem Variables are initialised
* at the top of the exec as follows:
*              fileext.n - the extension for which an EA must be set
*              fileea.n  - the corresponding text for the 'type' 
*                          extended attribute
*              entries   - the number of entries in the tables
*                          increment this when you add a new value
**********************************************************************/
/* Code    */
arg filepath
/*  Extensions   */
fileext.1 = 'PRG'
fileext.2 = 'CHA'
fileext.3 = 'REP'
fileext.4 = 'TAB'
fileext.5 = 'ME'
fileext.6 = 'APN'
fileext.7 = 'LIB'
fileext.8 = 'WIN'
fileext.9 = 'CMD'
fileext.10 = 'PGM'
fileext.11 = 'APL'
fileext.12 = 'MAK'
fileext.13 = 'MNT'
fileext.14 = 'MNU'
fileext.15 = 'WDW'
fileext.16 = ''
/*  Extended Attributes    */
fileea.1 = 'IBMPROGRAM'
fileea.2 = 'IBMCHART'
fileea.3 = 'IBMREPORT'
fileea.4 = 'IBMTABLE'
fileea.5 = 'Plain Text'
fileea.6 = 'IBMAPPLICATN'
fileea.7 = 'IBMAPPLICATN'
fileea.8 = 'IBMWINDOW'
fileea.9 = 'OS/2 Command File' || x2c(00)
fileea.10 = 'IBMPROGRAM'
fileea.11 = 'IBMAPPLICATN'
fileea.12 = 'IBMMAKE'
fileea.13 = 'IBMSQLSTATEMENT'
fileea.14 = 'IBMMENU'
fileea.15 = 'IBMWINDOW'
fileea.16 = 'IBMTABLE'
/*  No of entries in above tables  */
entries = 16
colon = ':'
bslash= '\'


/* Register Rexx Functions    */
call RxFuncAdd 'SysPutEA', 'RexxUtil', 'SysPutEA'
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

/* Set up full EA for SysPutEA function              */
do i = 1 to entries
   fullea.i = 'DFFF00000100FDFF'x || d2c(length(fileea.i)) || '00'x || fileea.i
end
/* Get a list of files with each extension specified */
x = length(filepath)
if x <>  0 then
   if substr(filepath,x,1) <> bslash & substr(filepath,x,1) <> colon then
	filepath = filepath || bslash

/* Set rc to 0.  This will be increased if errors occur  */
rc = 0

do i = 1 to entries
filespec = filepath || '*.' || fileext.i
   if SysFileTree(filespec,filenames,'FO') = 0 then
      do j = 1 to filenames.0
         x = SysPutEA(filenames.j, ".TYPE", fullea.i)
         if x  <> 0 then do 
            say 'SysPutEA failed for' filenames.j 'Return Code' x
      	    rc = rc + 1
      	    end
            else nop
         end 
       else 
	 do      /* SysFileTree */
         say 'Directory search failed for filespec'
         rc = 999
         leave
         end
      end     /* do i = 1 to entries */
return rc
