/*********************************************************************
*                                                                    *
*  LXPROTO - A simple prototype statement inserter for LPEX.         *
*                                                                    *
*            (C) Copyright IBM Corporation 1989, 1997                *
*                                                                    *
**********************************************************************
*                                                                    *
*  The PROTO external command (LxPROTO.DLL) is best tied to a key    *
*  (such as Ctrl+R).  When invoked, it queries the contents of the   *
*  current line.  If there is a word under the cursor or immediately *
*  before it, PROTO checks whether this word, prefixed with 'xxx'    *
*  (where 'xxx' is the parameter supplied to PROTO), is a current    *
*  global variable.  If so, the value of the variable is treated as  *
*  a set of elements to be inserted at the current position.  If no  *
*  parameter is supplied, '#' is used.                               *
*                                                                    *
*  Thus, given the global variable definition:                       *
*                                                                    *
*     SET GLOBAL.#if /if (?) {//} else {//}                          *
*                                                                    *
*  and the actionkey definition:                                     *
*                                                                    *
*     SET ACTION.c-r proto                                           *
*                                                                    *
*  pressing Ctrl+R when the cursor is on a line under the word "if", *
*  will cause LPEX to replace the text with this, the new cursor     *
*  position denoted by the underscore:                               *
*                                                                    *
*      if (_) {                                                      *
*                                                                    *
*      } else {                                                      *
*                                                                    *
*      }                                                             *
*                                                                    *
*  Note that:                                                        *
*   - BLOCK SET CHARACTER WORD is used to locate the word to use as  *
*     a base for the global variable.  This allows using accented    *
*     characters and numerics, but not delimiters and specials.      *
*   - The new text is aligned with the word on the original line.    *
*   - The cursor is positioned at the first ? in the replacement     *
*     text (or, if no ? in the replacement text, at the start of     *
*     the first line).                                               *
*   - The line separator ("/" in the example above) will be the      *
*     first non-blank character in the variable definition.          *
*   - Any text after the original word will be placed at the end     *
*     of the last line of the replacement text.                      *
*                                                                    *
**********************************************************************
*                                                                    *
* Operation:                                                         *
*  1. identify the word under the cursor;  if none, return.          *
*  2. prefix word with 'xxx' and check if this is a global variable  *
*  3. if no, return.                                                 *
*  4. scan variable definition, inserting lines                      *
*  5. append remainder of original line to last line                 *
*  6. set position at first "?" (or first line).                     *
*                                                                    *
*********************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "lpexapi.h"


#define  BLANK  ' '


/* A large work area for LPEX calls */
char result[MAXQUERY];                             /* result used for queries */
char quer[100] = "GLOBAL.";         /* used to test if GLOBAL variable exists */
char posi[100];                                       /* used to set position */
char newl[300];                                /* used to hold inserted lines */


/* lxxquer() - return pointer to QUERY PARAMETER value */
char* lxxquer (char* item, char* buff)
{
   char* p;

   lxquery(item, buff);   /* the editor returns "ITEM value" string into buff */
   p = buff + strlen(item);                                 /* step over ITEM */
   if (*p == BLANK) p++;                           /* and the following blank */
   return p;
}


/* lxxqnum() - returns the result of a numerical QUERY PARAMETER as an int */
int   lxxqnum (char* item)
{
   char work[100];
   return atoi(lxxquer(item, work));
}


/* lxmain() - external command PROTO's entry point */
int   lxmain (char* arg)
{
   char *p, *q, *r, *s, buff[300];
   int  i;
   int  k;                                /* position of first "?" in pattern */
   char delim;                                   /* line delimiter in pattern */
   int  join1;                                    /* true if text before word */
   int  join2;                                     /* true if text after word */
   int  offset;                    /* start of word offset from start of line */
   int  cnt;                                         /* counts inserted lines */
   char autoparse[32];                           /* remembers AUTOPARSE state */
   int  noword = 0;           /* indicates whether a word found at the cursor */

   /* check for PROTO parameter (GLOBAL variable prefix) */
   while (*arg == BLANK) arg++;                        /* skip leading blanks */
   p = quer + strlen("GLOBAL.");
   if (*arg == '\0')                             /* set either default prefix */
      strcpy(p, "#");
   else {                                  /* or prefix supplied as parameter */
      while (*arg != BLANK && *arg != '\0')
         *p++ = *arg++;
      *p = '\0';
      }

   /* check if word at cursor is a recognized prototype */
   if (lxcmd("BLOCK SET WORD CHARACTER") != 0) /* character-mark current word */
      noword = 1;                                        /* can't find a word */
   else {
      p = lxxquer("CONTENT", result);
      lxcmd("BLOCK FIND");
      offset = lxxqnum("POSITION") - 1;
      q = p + offset;                            /* q points to start of word */
      lxcmd("BLOCK FIND END");
      i = lxxqnum("POSITION");
      r = p + i;                        /* r points to char after end of word */
      lxcmd("BLOCK CLEAR");

      if ((i = r - q) > 30)                                /* word max length */
         return 0;

      s = quer + strlen(quer);
      memcpy(s, q, i);               /* set up query: "GLOBAL.<prefix><word>" */
      *(s+i) = '\0';
      s = lxxquer(quer, buff);                               /* and get value */
      noword = (*s == '\0');                 /* record if there isn't one set */
      }

   if (noword) {
      /* lxcmd("MSG PROTO - cursor is not positioned on a prototype word."); */
      lxcmd("ALARM");
      return 0;
      }

   /* expand the prototype word */
   lxquery("AUTOPARSE", autoparse);       /* remember current AUTOPARSE state */
   lxcmd("SET AUTOPARSE OFF");                   /* and set it off until done */
   lxcmd("MARK SET PROTO.01");                   /* remember start of changes */
   join1 = join2 = 0;
   if (q != p) {                                        /* if preceding text: */
      *q = '\0';
      lxcall("INSERT", p);                              /*    insert before   */
      join1 = 1;
      }
   if (*r != '\0') {                                    /* if following text: */
      lxcall("INSERT", r);                              /*    insert after    */
      join2 = 1;
      lxcmd("PREV");
      }

   q = s;
   while (*q == BLANK) q++;                             /* skip over blank(s) */
   delim = *q++;                               /* get and skip over delimiter */

   k = 0;
   p = newl;                               /* first line doesn't have padding */
   for (cnt = 0; *q != '\0'; cnt++) {            /* for the entire pattern... */
      if (cnt == 1) {                            /* later lines do get padded */
         memset(newl, BLANK, offset);                    /* pad start of line */
         p = newl + offset;
         }
      r = p;
      while (*q != delim && *q != '\0') {         /* for each line in pattern */
         if (k == 0 && *q == '?')                       /* if it is first "?" */
            k = r - p + 1;                              /*   remember it      */
         *r++ = *q++;
         }
      *r = '\0';
      lxcall("INSERT", newl);                                  /* insert line */
      if (cnt == 0 && join1 == 1) {                 /* join to preceding text */
         lxcmd("PREV");
         lxcmd("SPLITJOIN JOIN");
         }
      if (k > 0) {                                      /* if a "?" was found */
         sprintf(posi, "SET POSITION %u", offset + k);
         lxcmd(posi);                                     /* put cursor there */
         lxcmd("MARK SET PROTO.02");                         /* note position */
         k = -1;                              /* indicate mark 2 has been set */
         }
      if (*q == delim) ++q;                                 /* skip delimiter */
      }

   if (join2 == 1)                       /* join last line to succeeding text */
      lxcmd("SPLITJOIN JOIN");

   /* go back to original line and delete it */
   lxcmd("MULT ,MARK FIND PROTO.01 ,MARK CLEAR PROTO.01 ,DELETE");

   /* if "?" was found, put cursor there & clear the "?" */
   if (k < 0) {
      lxcmd("MULT ,MARK FIND PROTO.02 ,MARK CLEAR PROTO.02");
      if (strcmp("ON", lxxquer("INSERTING", buff)) == 0)  /* a.- insert mode  */
         lxcmd("PRIMITIVE DELETECHAR");
      else                                                /* b.- replace mode */
         lxcmd("MULT ,PRIMITIVE REPLACECHAR \" \" ,PRIMITIVE CURSORLEFT");
      }
   lxcall("SET", autoparse);                       /* restore AUTOPARSE state */

   return 0;
}
