 /* REXX */
 /*********************************************************************/
 /* Licensed Material - Property of IBM                               */
 /* 5639-B92 , 5648-A25 , 5688-197 , 5639-D65 , 5688-235              */
 /* (C) Copyright IBM Corp., 1997, 1998                               */
 /* All rights reserved.                                              */
 /* US Government Users Restricted Rights - Use, duplication or       */
 /* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
 /*********************************************************************/
 trace off;
 signal on novalue;
 parse upper arg dsname rest;
 if dsname = '' then
   do;
   say 'ERROR No data set name specified';
   exit 16;
   end;
 if pos('(',dsname) > 0 then
   do;
   say 'ERROR Member not allowed';
   exit 16;
   end;
 if substr(dsname,length(dsname),1) = '*' then  /* special case */
   do;
   len = length(dsname) - 1;
   dsname = substr(dsname,1,len);
   if substr(dsname,length(dsname),1) = '*' then
     do;
     len = length(dsname) - 1;
     dsname = substr(dsname,1,len);
     dsname = "'"dsname".@@TMPC@@.CLIST'";
     end;
   else
     dsname = "'"dsname".IWZ.@@TMPC@@.CLIST'";
   end;
 if sysdsn(dsname) = 'OK' then
   do;
   say 'OK';
   exit 0;
   end;
 junk = outtrap('tsoout.');
 'ALLOCATE FILE(IGYFTEMP) NEW REUSE DATASET('dsname') DSORG(PS)',
   ' TRACKS SPACE(2 2) RECFM(F B) LRECL(80) BLKSIZE(6160)';
 allocate_rc = rc;
 junk = outtrap('OFF');
 'FREE FILE(IGYFTEMP)';
 if allocate_rc = 0 then
   do;
   say 'OK';
   exit 0;
   end;
 if tsoout.0 > 0 then
   say 'ERROR' tsoout.1;
 else
   say 'ERROR';
 if tsoout.0 > 1 then
   do;
   do ii = 2 to tsoout.0;
     say strip(tsoout.ii,'T');
     end;
   end;
 exit allocate_rc;
