 /* REXX */
 /*********************************************************************/
 /* Licensed Material - Property of IBM                               */
 /* 5639-B92 , 5648-A25 , 5688-197 , 5639-D65 , 5688-235              */
 /* (C) Copyright IBM Corp., 1997, 1998                               */
 /* All rights reserved.                                              */
 /* US Government Users Restricted Rights - Use, duplication or       */
 /* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
 /*********************************************************************/
 trace off;
 signal on novalue;
 parse upper source x x x x sigyclst rest;
 if sigyclst = '?' then
   do;
   say 'Cannot determine dataset name containing IGYFPROC';
   exit 16;
   end;
 parse arg theargs;
 theargs = strip(theargs,'B');
 if substr(theargs,1,2) <> '??' then
   do;
   if substr(theargs,1,4) <> 'IGYF' then
     theargs = 'IGYF'||theargs;
   theargs = '??*??'||theargs;
   end;
 parse upper var theargs '??' procdsns '??' dummy;
 parse var theargs '??' dummy '??' the_args;
 fromtr = '!|'||'bd'x;
 the_args = translate(the_args,"'''",fromtr);
 if pos('-',the_args) > 0 then
   do;
   restcmd = the_args;
   the_args = '';
   do forever;
     if pos('-',restcmd) = 0 then
       do;
       the_args = the_args||restcmd;
       leave;
       end;
     parse var restcmd rest1 '-' restcmd;
     hexchars = substr(restcmd,1,2);
     hexchars = translate(hexchars);
     restcmd = substr(restcmd,3);
     testhex =,
       translate(hexchars,'FFFFFFFFFFFFFFFF','0123456789ABCDEF');
     if testhex <> 'FF' then
       do;
       say 'Invalid hex representation';
       exit 16;
       end;
     hexchar = x2c(hexchars);
     the_args = the_args||rest1||hexchar;
     end;
   end;
 procdsn2 = "";
 do ii = 1 to words(procdsns);
   if word(procdsns,ii) <> '*' then
     procdsn2 = procdsn2 "'"word(procdsns,ii)"'";
   else
     procdsn2 = procdsn2 "'"sigyclst"'";
   end;
 "ALLOCATE FILE(SYSPROC) REUSE SHR DATASET("procdsn2")";
 allocate_rc = rc;
 if allocate_rc <> 0 then
   exit allocate_rc;
 ADDRESS TSO the_args;
 tso_rc = rc;
 "FREE FILE(SYSPROC)";
 exit tso_rc;
