 /* REXX */
 /*********************************************************************/
 /* Licensed Material - Property of IBM                               */
 /* 5639-B92 , 5648-A25 , 5688-197 , 5639-D65 , 5688-235              */
 /* (C) Copyright IBM Corp., 1997, 1998                               */
 /* All rights reserved.                                              */
 /* US Government Users Restricted Rights - Use, duplication or       */
 /* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
 /*********************************************************************/
 trace off;
 signal on novalue;
 parse arg iwzmtso;
 if iwzmtso = '' then
   exit 0;
 fromtr = '!|'||'bd'x;
 iwzmtso = translate(iwzmtso,"'''",fromtr);
 if pos('-',iwzmtso) > 0 then
   do;
   restcmd = iwzmtso;
   iwzmtso = '';
   do forever;
     if pos('-',restcmd) = 0 then
       do;
       iwzmtso = iwzmtso||restcmd;
       leave;
       end;
     parse var restcmd rest1 '-' restcmd;
     hexchars = substr(restcmd,1,2);
     hexchars = translate(hexchars);
     restcmd = substr(restcmd,3);
     testhex =,
       translate(hexchars,'FFFFFFFFFFFFFFFF','0123456789ABCDEF');
     if testhex <> 'FF' then
       do;
       say 'Invalid hex representation';
       exit 16;
       end;
     hexchar = x2c(hexchars);
     iwzmtso = iwzmtso||rest1||hexchar;
     end;
   end;
 address tso iwzmtso;
 tso_rc = rc;
 exit tso_rc;
