 /* REXX */
 /*********************************************************************/
 /* Licensed Material - Property of IBM                               */
 /* 5639-B92 , 5648-A25 , 5688-197 , 5639-D65 , 5688-235              */
 /* (C) Copyright IBM Corp., 1997, 1998                               */
 /* All rights reserved.                                              */
 /* US Government Users Restricted Rights - Use, duplication or       */
 /* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
 /*********************************************************************/
 trace off;
 signal on novalue;
 parse upper arg tempsave dsname member recfm lrecl numrec timestamp,
   language rest;
 if timestamp = '' then
   do;
   call message 01;
   exit 16;
   end;
 if language = '' then
   language = 'ENG';
 tempsave = "'"tempsave"'";
 memname = "'"dsname"("member")'";
 igyfsave_rc = 0;
 'IGYFLIBS';
 igyfvals_rc = rc;
 if igyfvals_rc <> 0 then
   do;
   call message 02 igyflibs_rc;
   exit igyfvals_rc;
   end;
 modlib = '';
 do while queued() > 0;
   pull usertype uservalue rest;
   select;
     when usertype = 'COBOL' then
       modlib = uservalue;
     otherwise
       nop;
     end;
   end;
 if modlib = '' then
   do;
   call message 03;
   exit 16;
   end;
 xx = outtrap('tsoout.');
 allocfail = 'none';
 'ALLOCATE DA('memname') FILE(IGYFSAVO) REUSE OLD';
 allocate_rc = rc;
 if allocate_rc <> 0 then
   do;
   allocfail = 'sysut2';
   call errexit;
   end;
 do ii = 1 to 54;
   if ii > 53 then
     do;
     allocfail = 'sysut1';
     call errexit;
     end;
   'ALLOCATE DA('tempsave') FILE(IGYFSAVI) REUSE OLD';
   allocate_rc = rc;
   if allocate_rc = 0 then
     leave;
   "CALL '"modlib"(IGYFWAIT)'";
   igyfwait_rc = rc;
   if igyfwait_rc <> 0 then
     do;
     call message 04 'IGYFWAIT';
     call errexit;
     end;
   end;
 recfm = substr(recfm||'  ',1,2);
 lrecl = substr('0000'||lrecl,length(lrecl),5);
 numrec = substr('0000000'||numrec,length(numrec),8);
 timestamp = substr(timestamp||'            ',1,12);
 saveparms = recfm'.'lrecl'.'numrec'.'timestamp;
 "CALL '"modlib"(IGYFSAVE)' '"saveparms"'";
 igyfsave_rc = rc;
 if igyfsave_rc >= 0 & igyfsave_rc < 100 then
   do;
   call message 04 'IGYFSAVE';
   call errexit;
   end;
 if igyfsave_rc >= 100 then
   igyfsave_rc = igyfsave_rc - 100;
 if igyfsave_rc <> 0 then
   call errexit;
 call freefile;
 xx = outtrap('OFF');
 say 'OK'; /* This must not be translated for NLS */
 exit 0;
 /* */
 errexit:
 call freefile;
 xx = outtrap('OFF');
 if tsoout.0 > 0 | igyfsave_rc <> 0 then
   call message 05;
 else
   call message 06;
 if tsoout.0 > 0 then
   do;
   do ii = 1 to tsoout.0;
     say strip(tsoout.ii,'T');
     end;
   end;
 if allocfail <> 'none' then
   do;
   call message 07;
   if allocfail = 'sysut2' then
     call mesage 08;
   call message 09;
   end;
 if igyfsave_rc <> 0 then
   do;
   call message 10 memname;
   call message 11 igyfsave_rc;
   if igyfsave_rc = 24 then
     call mesaage 12;
   if igyfsave_rc = 28 then
     call message 13;
   if igyfsave_rc = 32 then
     call message 14;
   if igyfsave_rc = 36 then
     call message 15;
   if igyfsave_rc < 0 then
     do;
     abend = d2x(igyfsave_rc,8);
     rcpos = 0 - igyfsave_rc;
     abendpos = d2x(rcpos,8);
     call message 16 abend abendpos;
     end;
   end;
 exit 16;
 /* */
 freefile:
 'FREE FILE(IGYFSAVI,IGYFSAVO)';
 return;
/* */
message:
parse arg iwz_message_num,
          iwz_message_arg1 '\\',
          iwz_message_arg2 '\\',
          iwz_message_arg3 '\\',
          iwz_message_arg4 '\\',
          iwz_message_arg5 '\\',
          iwz_message_arg6 '\\',
          iwz_message_arg7 '\\',
          iwz_message_arg8;
select;
  when language = 'ENG' then
    call message_eng;
  when language = 'JPN' then
    call message_jpn;
  otherwise
    call message_eng;
  end;
return;
/* */
message_eng:
select;
 
when iwz_message_num = 1 then do;
say 'ERROR Input missing';
end;
 
when iwz_message_num = 2 then do;
say 'ERROR IGYFLIBS return code =' igyflibs_rc;
end;
 
when iwz_message_num = 3 then do;
say 'ERROR IGYFLIBS is invalid';
end;
 
when iwz_message_num = 4 then do;
say 'ERROR Module' iwz_message_arg1 'cannot be accessed';
end;
 
when iwz_message_num = 5 then do;
say 'ERROR - MVS messages follow';
end;
 
when iwz_message_num = 6 then do;
say 'ERROR - no MVS messages';
end;
 
when iwz_message_num = 7 then do;
say;
say 'You may be running with a Network File System (NFS) client';
say 'that does not support passing NFS timeout attributes to the';
say 'MVS NFS Server.  If you are using such an NFS client you need';
say 'to have the readtimeout and writetimeout values in the';
say 'workstation MVSINFO.DAT file reflect the various MVS NFS';
say 'server default timeout values.'
end;
 
when iwz_message_num = 8 then do;
say;
say 'After you start editing, you will not be able to save the';
say 'file until the maximum of the MVS NFS server readtimeout';
say 'and attrtimeout default values has expired.';
end;
 
when iwz_message_num = 9 then do;
say;
say 'See the Trouble-shooting section in the online document';
say '"Working with Host Applications" for more information.';
say;
end;
 
when iwz_message_num = 10 then do;
say 'Attempted to use IGYFSAVE program to update' iwz_message_arg1;
end;
 
when iwz_message_num = 11 then do;
say 'IGYFSAVE RC =' iwz_message_arg1;
end;
 
when iwz_message_num = 12 then do;
say 'Sufficient main storage could not be obtained to hold all';
say 'the records.';
end;
 
when iwz_message_num = 13 then do;
say 'The temporary file does not have the correct RECFM and/or';
say 'LRECL.  You may be using an incorrect version of the NFS';
say 'client.';
end;
 
when iwz_message_num = 14 then do;
say 'The temporary file does not have the excepted number of';
say 'records.  The file system (NFS or SdU) may not have written';
say 'all of the data.';
end;
 
when iwz_message_num = 15 then do;
say 'The temporary file does not have the correct timestamp';
say 'record.  The file system (NFS or SdU) may not have written';
say 'all of the data.';
end;
 
when iwz_message_num = 16 then do;
say 'IGYFSAVE abended, abend code =' iwz_message_arg1;
end;
 
otherwise
say 'Invalid message number' iwz_message_num;
end;
return;
/* */
message_jpn:
say 'Japanese message';
select;
 
when iwz_message_num = 1 then do;
say 'ERROR Input missing';
end;
 
when iwz_message_num = 2 then do;
say 'ERROR IGYFLIBS return code =' igyflibs_rc;
end;
 
when iwz_message_num = 3 then do;
say 'ERROR IGYFLIBS is invalid';
end;
 
when iwz_message_num = 4 then do;
say 'ERROR Module' iwz_message_arg1 'cannot be accessed';
end;
 
when iwz_message_num = 5 then do;
say 'ERROR - MVS messages follow';
end;
 
when iwz_message_num = 6 then do;
say 'ERROR - no MVS messages';
end;
 
when iwz_message_num = 7 then do;
say;
say 'You may be running with a Network File System (NFS) client';
say 'that does not support passing NFS timeout attributes to the';
say 'MVS NFS Server.  If you are using such an NFS client you need';
say 'to have the readtimeout and writetimeout values in the';
say 'workstation MVSINFO.DAT file reflect the various MVS NFS';
say 'server default timeout values.'
end;
 
when iwz_message_num = 8 then do;
say;
say 'After you start editing, you will not be able to save the';
say 'file until the maximum of the MVS NFS server readtimeout';
say 'and attrtimeout default values has expired.';
end;
 
when iwz_message_num = 9 then do;
say;
say 'See the Trouble-shooting section in the online document';
say '"Working with Host Applications" for more information.';
say;
end;
 
when iwz_message_num = 10 then do;
say 'Attempted to use IGYFSAVE program to update' iwz_message_arg1;
end;
 
when iwz_message_num = 11 then do;
say 'IGYFSAVE RC =' iwz_message_arg1;
end;
 
when iwz_message_num = 12 then do;
say 'Sufficient main storage could not be obtained to hold all';
say 'the records.';
end;
 
when iwz_message_num = 13 then do;
say 'The temporary file does not have the correct RECFM and/or';
say 'LRECL.  You may be using an incorrect version of the NFS';
say 'client.';
end;
 
when iwz_message_num = 14 then do;
say 'The temporary file does not have the excepted number of';
say 'records.  The file system (NFS or SdU) may not have written';
say 'all of the data.';
end;
 
when iwz_message_num = 15 then do;
say 'The temporary file does not have the correct timestamp';
say 'record.  The file system (NFS or SdU) may not have written';
say 'all of the data.';
end;
 
when iwz_message_num = 16 then do;
say 'IGYFSAVE abended, abend code =' iwz_message_arg1;
end;
 
otherwise
say 'Invalid message number' iwz_message_num;
end;
return;
