 /* REXX */
 /*********************************************************************/
 /* Licensed Material - Property of IBM                               */
 /* 5639-B92 , 5648-A25 , 5688-197 , 5639-D65 , 5688-235              */
 /* (C) Copyright IBM Corp., 1997, 1998                               */
 /* All rights reserved.                                              */
 /* US Government Users Restricted Rights - Use, duplication or       */
 /* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
 /*********************************************************************/
 trace off;
 signal on novalue;
 parse upper source x x x x dsname rest;
 if dsname = '?' then
   do;
   say 'Cannot determine dataset name containing IGYFCMD';
   exit 16;
   end;
parse arg the_args;
if substr(the_args,1,1) = '/' then
  do;
  quiet = 'yes';
  the_args = substr(the_args,2);
  end;
else
  quiet = 'no';
 parse upper var the_args the_args;
 the_args = strip(the_args,'L');
 if substr(the_args,1,4) <> 'IGYF' then
   the_args = 'IGYF'||the_args;
 fromtr = '!|'||'bd'x;
 the_args = translate(the_args,"'''",fromtr);
 "ALLOCATE FILE(SYSPROC) REUSE SHR DATASET('"dsname"')";
 allocate_rc = rc;
 if allocate_rc <> 0 then
   exit allocate_rc;
 if quiet = 'no' then
   say 'Will execute on TSO:' the_args;
 ADDRESS TSO the_args;
 tso_rc = rc;
 if quiet = 'no' then
   say 'TSO return code =' tso_rc;
 "FREE FILE(SYSPROC)";
 exit tso_rc;
