
/*
 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 +
 +  ray_trace.h  -- misc definitions used in ray tracing
 +
 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */

/*
 * #define MAX_DEPTH  4   * maximum depth of ray_tracing recursion * 
 */
#define MAX_DEPTH  40  /* maximum depth of ray_tracing recursion */



#define FREE_SPACE_LIMIT  90000

typedef struct {

     Vector d_AF;
     Vector X_bar, Y_bar;
     Viewport vp;

     int  obj_num;
     Obj_Props  obj_props[OBJ_MAX];
     Obj  obj_list[OBJ_MAX];

     Light  lights[LIGHTS_MAX];
     float PhongConst;

     Vector pix_buf[800][800];
     int curr_scan;
     int npix;
     int nscan;

	 int ScanSetSize;
	 int FirstScan;
	 int ScanLimit;
     int depth_limit;

     struct shared_heap_type {
         int allocated_space;
         char *free_space_ptr;
         char free_space[FREE_SPACE_LIMIT];
         int end_of_free_space;
        } Sh_Heap;

} SharedType;

extern SharedType *shared;


extern float res;     /* screen resolution in pixels */

extern int num_T;
extern int nIter;

extern FILE    *ofp;

extern int nscan, npix;



extern Boolean  debug_flag;
extern Boolean  triangle_flag;

extern Boolean  super_sample_flag;

extern Boolean XmitPixelsFlag;
extern Boolean WritePixelsFlag;



void RayTrace();     /* function definition for ray tracing driver */

Vector RT_Trace(Ray i_ray, float n_i, int depth);

Vector RT_DirectionVector(float pix, float scan);

void RT_Configure(char *config_file);

void RT_TextureMap(Vector pt, Obj *obj_ptr, Vector *Od);

Vector RT_SuperSample(Vector Iul, Vector Iur, Vector Ill, Vector Ilr,
                      Ray    Rul, Ray    Rur, Ray    Rll, Ray    Rlr,
                      float scan, float pix, int d);

Vector RT_Shade(Vector RT_pt, Vector Pt_norm, Vector patch_norm, Ray RT_Iray,
                Obj *obj_ptr, Obj_Props *prop_ptr, int depth, float n_i);

Vector RT_RefractionDirection(Vector I, Vector N, float n_i, float n_t);

void RT_SetViewParams();

void RT_SetPixels(Vector Ipix[], int scan, int npix);
void RT_XmitPixels (short buffer[], int scan_no, int npix);
int  RT_Send (int sd, char buf[], int bytes);

