
/*
 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 +
 +  vector.h  -- contains function declarations for all functions that 
 +               implement vector operations.
 +
 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */


void Cross_Product(Vector *A, Vector *B, Vector *C);

void Vector_Put_Col(Vector *vec, float matrix[][4], int col);


float Dot_Product(Vector *A, Vector *B);

float vector_len(Vector *vec);

Boolean Vector_eq(Vector *v1, Vector *v2);
Boolean vgt_lim(Vector *v1, Vector *v2);


Vector NCross_Product(int n, Vector pts[]);

Vector VectorScaler_Division(Vector *vec, float scaler);
Vector VectorScaler_Product(Vector *vec, float scaler);

Vector Vector_Difference(Vector *v1, Vector *v2);
Vector Vector_Sum(Vector *v1, Vector *v2);
Vector Vector_Average(Vector *v1, Vector *v2);

float vmax_element(Vector *vec);

Vector vproduct(Vector *vec1, Vector *vec2);
Vector vmax(Vector *vec1, Vector *vec2);
Vector vmin(Vector *vec1, Vector *vec2);


void vset(Vector *vec, float x, float y, float z);
void vclamp(Vector *vec, float max);

