
/*
 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 +
 +  types.h -- contains various useful structures and defined data types.  It
 +             is expected that this header file will grow with time.
 +
 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 */


#define FALSE  0
#define TRUE   1


typedef int Boolean;

typedef struct point_type {
    float x;
    float y;
   } Point;

  
typedef struct device_point_type {
    short x;
    short y;
   } DevPt;
   
  
typedef struct point_uv_type {
    float u;
    float v;
   } PT_uv;
   


typedef struct vector_type {
    float x;
    float y;
    float z;
   } Vector;



typedef struct ray_type {
    Vector origin;
    Vector dir;
   } Ray;




  
typedef struct region_type {
    DevPt min_pt;
    DevPt max_pt;
   } Region;
   


typedef struct polygon_type {
    int  num_pts;
    Vector  *pts;
   } RT_Polygon;


typedef struct triangle_type {
    int v[4];
    Vector normal;
    Vector ce;
   } Triangle;


typedef struct surface_type {
    int num_triang;
    Triangle *triangs;
   } Surface;


typedef struct obj_type {
    int label;
    char *ptr;
   }  Obj;


typedef struct obj_sphere_type {
    Vector  center_pt;
    Vector  radius_pt;
   } Sphere_Obj;


typedef struct obj_poly_mesh_type {
    Vector F;
    Vector A;
    Vector U;
    float  v;

    int  num_vert;
    Vector  *data;

    int  num_surf;
    Surface  *surfs;

    Vector  *surf_norms[100];
    Boolean  *surf_pnorm_flags;
    Boolean  *surf_tnorm_flags;

    Sphere_Obj  b_sph;
   } Poly_Mesh_Obj;





typedef struct obj_rectangle_type {
    Vector  corners[4];
    Vector  max_pt;
    Vector  min_pt;
    int  normal;

    Sphere_Obj  b_sph;
   } Rect_Obj;



typedef struct object_default_type {
    Vector zmax;
    Vector zmin;

    Vector F;
    Vector A;
    Vector U;
    float  v;
   } Obj_View;



typedef struct viewport_type {
    Region scr_reg;
    Boolean display;
    Boolean view_params;

    float R[4][4];
    Boolean Rset;

    Vector F;
    Vector A;
    Vector U;
    float  v;

   } Viewport;


  
typedef struct light_type  {
    Boolean directed;
    Boolean on;

    Vector L_pt;

    Vector L_a;

    Vector I;

    float ro;
    float cos_delta;
   } Light;
   


typedef struct object_properties_type  {

    Vector Od_in;
    Vector Od_out;
    Boolean txt_flg;

    Vector Os;
   
    float Ka;
    float Kd;
    float Ks;

    float Kt;
    float n;

   } Obj_Props;
