

#include <stdio.h>
#include <assert.h>
 
#include "RTTypes.h"
#include "RTObjOps.h"
#include "RTIMOps.h"
#include "RayTrace.h"


char * Sh_malloc(unsigned size);
char * Sh_calloc(unsigned  elem_count,  unsigned size);




/*
 *******************************************************************************
 *
 *  Name:  Sh_calloc
 *
 *  Purpose:  this routine allocates space for an array of "elem_count" elements
 *            where each element contains "size" bytes.  The heap used for
 *            allocation is setup in the calypso shared memory segment.
 *
 *
 *
 *  Input Parameters
 *
 *     elem_count -	number of elements to be allocated
 *     size - byte count of each element
 *
 *
 *  Output Parameters
 *
 *     none
 *
 *******************************************************************************
 */
char *
   Sh_calloc(unsigned  elem_count,  unsigned size)
      {
       char * chunk_ptr;

       chunk_ptr = Sh_malloc( (unsigned) (elem_count * size) );
       return(chunk_ptr);
      }




/*
 *******************************************************************************
 *
 *  Name:  Sh_malloc
 *
 *  Purpose:  this routine returns a pointer to a block of "size"bytes.  The
 *            heap used for allocation is setup in the calypso shared memory
 *            segment.
 *
 *
 *
 *  Input Parameters
 *
 *     size - number of bytes to be allocated
 *
 *
 *  Output Parameters
 *
 *     none
 *
 *******************************************************************************
 */
char *
   Sh_malloc(unsigned size)
      {
       char *chunk_ptr;

       assert( (shared->Sh_Heap.allocated_space+size) < FREE_SPACE_LIMIT);
       shared->Sh_Heap.allocated_space += size;

       chunk_ptr = shared->Sh_Heap.free_space_ptr;
       shared->Sh_Heap.free_space_ptr += size;

       assert(shared->Sh_Heap.free_space_ptr <
                                  ((char *) &shared->Sh_Heap.end_of_free_space));

       return(chunk_ptr);
      }
