/* Simple REXX program to install the UCMenus toolkit */
/* Requires PKUNZIP2 program.                         */

'@echo off'

say 'NOTE: This installation requires that PKUNZIP2.EXE be available'
say '      in the current PATH for decompressing files.'
say ' '
say 'Enter directory for UCMENUS toolkit installation (or blank to quit):'
Dir = linein()
if strip(Dir) = '' then exit

/* Make new directory if necessary */

CurrDir = directory()
if directory(Dir)='' then do
  'mkdir 'Dir
  if RC<>0 then do
    say 'Unable to create directory "'||Dir||'".'
    say 'Installation halted.'
    call directory CurrDir
    exit
  end
end

/* Return to original directory and run install */
call directory CurrDir

'pkunzip2 ucmenus.pak -d -o 'Dir
if RC<>0 then do
  say ' '
  say 'PKUNZIP had errors or warnings... toolkit installation may not be complete.'
  say ' '
end
else do
  say ' '
  say 'UCMENUS toolkit installation complete.'
  say ' '
end

exit
