;*******************************************************}
;                                                       }
;       Turbo Pascal Version 7.0                        }
;       Graphic Vision Unit (GDos)                      }
;                                                       }
;       Copyright 1997,2000 Jason G Burgon              }
;                                                       }
;*******************************************************}

IDEAL
%TITLE "SOFTINT"
%NOINCL

include "gdos.inc"

CODESEG
    public SoftIntr     ; Call given application interrupt at Regs.CS:IP

ifndef _DPMI_

    public DosSoftIntr  ; Call given DOS/BIOS interrupt at Regs.CS:IP
    public DosFarCall   ; Call given DOS/BIOS far procedure

; function DosFarCall(var Regs: TRegisters): Word;

    proc DosFarCall
            push  bp
            mov   bp,sp
            push  ds                      ; { Save global Data Segment      }
            jmp   FarEnter
    endp DosFarCall

    proc   DosSoftIntr  ; Same as SoftIntr in real mode
endif

; function SoftIntr(var Regs: TRegisters): Word;

P8086
proc SoftIntr Regs: PRegisters
            push  ds                      ; { Save global Data Segment      }
P386N
            pushf                         ; { Push flags for the IRET       }
FarEnter:   lds   si,[Regs]
            push  cs                      ; { Push return address           }
            mov   eax,[si+TRegisters.EAX] ; { Load the registers for intrpt }
            push  offset @@Retn
            mov   ebx,[si+TRegisters.EBX]
            push  [si+TRegisters.CS]      ; { Push ISR call address (CS)    }
            mov   ecx,[si+TRegisters.ECX]
            mov   edx,[si+TRegisters.EDX]
            push  [si+TRegisters.IP]      ; { Push ISR call address (IP)    }
            mov   edi,[si+TRegisters.EDI]
            mov   es,[si+TRegisters.ES]
            push  [si+TRegisters.ESI]     ; { Push Regs.ESI                 }
            mov   ebp,[si+TRegisters.EBP]
            mov   ds,[si+TRegisters.DS]   ; { DS = Regs.DS                  }
            pop   esi                     ; { ESI = Regs.ESI                }
            retf  0                       ; { Far Call the ISR              }

@@Retn:     push  ebp                     ; { Push new Regs.EBP             }
            pushf                         ; { Push new Regs.Flags           }
            mov   bp,sp                   ; { Restore stack frame           }
            push  ds                      ; { Push new Regs.DS              }
            add   bp,6                    ; { Move past Flags, BP and DS    }
            push  esi                     ; { Push new Regs.ESI             }
            lds   si,[Regs]               ; { DS:SI = @Regs                 }
            mov   [si+TRegisters.EAX],eax
            mov   [si+TRegisters.EBX],ebx
            mov   [si+TRegisters.ECX],ecx
            mov   [si+TRegisters.EDX],edx
            mov   [si+TRegisters.EDX],edi
            mov   [si+TRegisters.ES],es
            pop   [si+TRegisters.ESI]     ; { pop new Regs.ESI              }
            pop   [si+TRegisters.DS]      ; { pop new Regs.DS               }
            pop   [si+TRegisters.Flags]   ; { pop new Regs.Flags            }
            pop   [si+TRegisters.EBP]     ; { pop new Regs.EBP              }
            pop   ds                      ; { Restore global Data Segment   }
P8086
            ret
endp SoftIntr

ifndef _DPMI_

endp DosSoftIntr

endif

ends
end
