/* Version of 94/02/26 by Peter Kanis */
/*******************************************************************************
*  Project     : TSTNGEN                            Date    : 93/11/16         *
*  Module      : DLL                                Version : 1                *
*  Filename    : tstngen.h                          Author  : Peter Kanis      *
********************************************************************************
*                                                                              *
*  Description : Export header file for Test Engine/2 API functions and        *
*                Macros.                                                       *
*                                                                              *
********************************************************************************
*                                                                              *
*  (c) ADD Consulting  All Rights Reserved                                     *
*                                                                              *
*******************************************************************************/

#ifndef TST_DEF
    #define TST_DEF

#if __cplusplus
    extern "C" {
#endif

/************************************************************************
*       constants and dimensions                                        *
*************************************************************************/

#define     TST_RESOURCE            11000   /* DO NOT CHANGE THIS CONSTANT */

#define     TST_PARAM_SIZE          20      /* Number of possible parameters    */
                                            /* passed to a function             */

/************************************************************************
*   Error & return constants.  (DO NOT CHANGE ANY OF THESE CONSTANTS)   *
************************************************************************/

#define     TST_OK                          0   
#define     TST_ERROR_FILE_OPEN             TST_RESOURCE + 111
#define     TST_ERROR_NO_TRACE_NAME         TST_RESOURCE + 112
#define     TST_ERROR_EOF                   TST_RESOURCE + 113
#define     TST_ERROR_FILE_READ             TST_RESOURCE + 114
#define     TST_ERROR_PARAMS                TST_RESOURCE + 115
#define     TST_ERROR_INVALID_LINE          TST_RESOURCE + 116


#define     TST_TRON                        "TRUE"  /* used with TST_ON() macro */
#define     TST_TROFF                       "FALSE" /* used with TST_ON() macro */

/************************************************************************
*    Macros   (These are default macros and may be modified as desired) *
************************************************************************/

#ifdef TST_NGEN

#define     TST_TRACE( formatstr, v1, v2, v3, v4)   TstWriteTrace( formatstr, v1, v2, v3, v4);
#define     TST_INIT( proc_name, lang_char)         TstInitProcess( proc_name, lang_char);
#define     TST_STOP()                              TstStopProcess();
#define     TST_REG( proc_name)                     TstRegisterProcess( proc_name);
#define     TST_END()                               TstDeRegister();
#define     TST_OPEN( file_name, append)            TstOpenTrace( file_name, append);
#define     TST_CLOSE()                             TstCloseTrace();
#define     TST_ONOFF( on_off)                      TstTraceOnOff( on_off);
#define     TST_DUMP( on_off)                       TstDumpOnOff( on_off);
#define     TST_DCLOSE()                            TstDumpClose();

#else

#define     TST_TRACE( formatstr, v1, v2, v3, v4)   ;
#define     TST_INIT( proc_name, lang_char)         ;
#define     TST_STOP()                              ;
#define     TST_REG( proc_name)                     ;
#define     TST_END()                               ;
#define     TST_OPEN( file_name, append)            ;
#define     TST_CLOSE()                             ;
#define     TST_ONOFF( on_off)                      ;
#define     TST_DUMP( on_off)                       ;
#define     TST_DCLOSE()                            ;

#endif


/************************************************************************/
/*                                                                      */
/*   DO NOT MODIFY ANY OF THE DECLARATIONS BEYOND THIS POINT.           */
/*                                                                      */
/************************************************************************/

/************************************************************************
*   types                                                               *
************************************************************************/

typedef PSZ     TST_ARRAY_TYPE[ TST_PARAM_SIZE + 1];

typedef PVOID   HSCRIPT;

/************************************************************************
*   Function prototypes.                                                *
************************************************************************/

USHORT   APIENTRY TstRegisterFunction( HSCRIPT, USHORT, PSZ, TST_ARRAY_TYPE);
HSCRIPT  APIENTRY TstInitTest( int, char*[]);
HSCRIPT  APIENTRY TstOpenScriptFile( PSZ);
USHORT   APIENTRY TstReadScriptLine( HSCRIPT, PSZ);
VOID     APIENTRY TstCloseScript( HSCRIPT);
USHORT   APIENTRY TstGetFunctionNum( HSCRIPT, PSZ);

VOID     APIENTRY TstWriteTrace( PSZ,...);
VOID     APIENTRY TstWriteString( PSZ);

VOID     APIENTRY TstCloseTrace( VOID);
VOID     APIENTRY TstOpenTrace( PSZ, BOOL);
BOOL     APIENTRY TstRegisterProcess( PSZ);
BOOL     APIENTRY TstInitProcess( PSZ, char);
VOID     APIENTRY TstStopProcess( VOID);
VOID     APIENTRY TstDeRegister( VOID);
VOID     APIENTRY TstTraceOnOff( PSZ);
VOID     APIENTRY TstAppendOnOff( PSZ);
VOID     APIENTRY TstDumpOnOff( PSZ); 
VOID     APIENTRY TstDumpClose( VOID);

#if __cplusplus
    }
#endif

#endif

/******************************************************************************/
/*                                                                            */
/*                         (c) ADD Consulting 1994                            */
/*                                                                            */
/*                               END OF FILE.                                 */
/*                                                                            */
/******************************************************************************/
