/*******************************************************************************
* FILE NAME: TreeCnr.cpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Class implementation of the class:                                         *
*     TreeCnr- Sample tree view container application                          *
* ---------------------------------------------------------------------------- *
* Warning: This file was generated by the VisualAge C++ Visual Builder.        *
* Modifications to this source file will be lost when the part is regenerated. *
*******************************************************************************/
#ifndef _IFRAME_
#include <iframe.hpp>
#endif

#ifndef _IMCELCV_
#include <imcelcv.hpp>
#endif

#ifndef _ICNRCOL_
#include <icnrcol.hpp>
#endif

#ifndef _IRECT_
#include <irect.hpp>
#endif

#ifndef _IPOINT_
#include <ipoint.hpp>
#endif

#ifndef _ITBAR_
#include <itbar.hpp>
#endif

#ifndef _ITBARBUT_
#include <itbarbut.hpp>
#endif

#ifndef _IENTRYFD_
#include <ientryfd.hpp>
#endif

#ifndef _IINFOA_
#include <iinfoa.hpp>
#endif

#ifndef _IVSEQ_H_
#include <ivseq.h>
#endif

#ifndef _PERSON_
#include "Person.hpp"
#endif

#ifndef _IMSGBOX_
#include <imsgbox.hpp>
#endif

#ifndef _INOTIFEV_
#include <inotifev.hpp>
#endif

#ifndef _IOBSERVR_
#include <iobservr.hpp>
#endif

#ifndef _ISTDNTFY_
#include <istdntfy.hpp>
#endif

#ifndef _TREECNR_
#include "TreeCnr.hpp"
#endif

#ifndef _IVBDEFS_
#include <ivbdefs.h>
#endif

#ifndef _ITRACE_
#include <itrace.hpp>
#endif


//*****************************************************************************
// Class definition for TreeCnrConn7
//*****************************************************************************
class TreeCnrConn7 : public IObserver, public IStandardNotifier {
public:
   virtual  ~TreeCnrConn7(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IToolBarButton * aSource, IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj > * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IToolBarButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : ToolBarButton1(buttonClickEvent) to TreeCnr(showTreeIconView))");
         try {target->showTreeIconView();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IToolBarButton * source;
   IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj > * target;


};   //TreeCnrConn7


//*****************************************************************************
// Class definition for TreeCnrConn9
//*****************************************************************************
class TreeCnrConn9 : public IObserver {
public:
   virtual  ~TreeCnrConn9(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IVSequence< Person * > * aSource, IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj > * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {      };
   void setTarget()
      {
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : People(this) to TreeCnr(items))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setItems(source);}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj >::itemsId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IVSequence< Person * > * source;
   IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj > * target;
   Boolean aligning;


};   //TreeCnrConn9


//*****************************************************************************
// Class definition for TreeCnrConn18
//*****************************************************************************
class TreeCnrConn18 : public IObserver, public IStandardNotifier {
public:
   virtual  ~TreeCnrConn18(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IVBVariablePartPointer<Person *> * aSource, IInfoArea * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (!source) return(*this);
      if (anEvent.notificationId() == IVBVariablePartPointer<Person *>::targetId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : SelPerson(this) to InfoArea1(customLogic))");
         try {codeSnippet(&anEvent);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member functions
   //---------------------------------------------------------------------------
   void codeSnippet(const INotificationEvent* event)
      {
      target->setText(
                 IString("Name: ") +
                 source->target()->name() +
                 IString("   Boss: ") +
                 source->target()->parentName() +
                 IString("   Phone: ") +
                 source->target()->phoneNumber()
      	   );
      };

   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IVBVariablePartPointer<Person *> * source;
   IInfoArea * target;


};   //TreeCnrConn18


//*****************************************************************************
// Class definition for TreeCnrConn29
//*****************************************************************************
class TreeCnrConn29 : public IObserver {
public:
   virtual  ~TreeCnrConn29(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj > * aSource, IVBVariablePartPointer<Person *> * aTarget)
      {source = aSource; target = aTarget; aligning = false; };
   void setSource()
      {      };
   void setTarget()
      {
      if (!target) return;
      if (aligning==false) {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : TreeCnr(selectedElement) to SelPerson(this))");
         ITRACE_DEVELOP(" setting target from source ");
         aligning = true;
         try {target->setTarget(source->selectedElement());}
         catch (IException& exc) {};
         aligning = false;
         }
      };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (!target) return(*this);
      if (anEvent.notificationId() == VBINITIALIZEID) setTarget();
      if ((anEvent.notificationId() == IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj >::selectId) && (source == &anEvent.notifier()))
         setTarget();  /* set target to source value */
      else
      if ((anEvent.notificationId() == IVBVariablePartPointer<Person *>::targetId) && (target == &anEvent.notifier()))
         setSource();  /* set source to target value */
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj > * source;
   IVBVariablePartPointer<Person *> * target;
   Boolean aligning;


};   //TreeCnrConn29


//*****************************************************************************
// Class definition for TreeCnrConn14
//*****************************************************************************
class TreeCnrConn14 : public IObserver, public IStandardNotifier {
public:
   virtual  ~TreeCnrConn14(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IToolBarButton * aSource, IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj > * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IToolBarButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : ToolBarButton3(buttonClickEvent) to TreeCnr(showTreeTextView))");
         try {target->showTreeTextView();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IToolBarButton * source;
   IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj > * target;


};   //TreeCnrConn14


//*****************************************************************************
// Class definition for TreeCnrConn15
//*****************************************************************************
class TreeCnrConn15 : public IObserver, public IStandardNotifier {
public:
   virtual  ~TreeCnrConn15(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IToolBarButton * aSource, TreeCnr * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

   //---------------------------------------------------------------------------
   // public member data
   //---------------------------------------------------------------------------
   static const INotificationId exceptionId;

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IToolBarButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : ToolBarButton(buttonClickEvent) to (customLogic))");
         try {codeSnippet(&anEvent);}
         catch (IException& exc) {notifyObservers(INotificationEvent(exceptionId, *this, true, IEventData((void *)&exc)));};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member functions
   //---------------------------------------------------------------------------
   Person * codeSnippet(const INotificationEvent* event)
      {
      IString addName = target->iAddEf->text();
      IVSequence<Person *> *col = target->iPeople;

      // ==========================================================
      // Don't allow addition if the object no objects are selected
      // ==========================================================
      if (target->iTreeCnr->numberOfSelections() == 0)
        ITHROW(IException("You must first select the parent of the object that you want to add."));

      // ==========================================================
      // Don't allow addition of two people with the same name
      // ==========================================================
      ICursor * colCursor = col->newCursor( );
      forCursor( *colCursor )
        {
        if (col->elementAt(*colCursor)->name() == addName)
          ITHROW(IException("Name already exists.  You cannot two people with the same name"));
        }

      // ==========================================================
      // Create and return a new person
      // ==========================================================
      Person * newPerson = target->iPersonFact->create();
      target->addObjectInTreeView(target->iTreeCnr, col, newPerson);

      return newPerson;


      };

   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IToolBarButton * source;
   TreeCnr * target;


};   //TreeCnrConn15

const INotificationId TreeCnrConn15::exceptionId = "TreeCnrConn15::exceptionId";

//*****************************************************************************
// Class definition for TreeCnrConn22
//*****************************************************************************
class TreeCnrConn22 : public IObserver, public IStandardNotifier {
public:
   virtual  ~TreeCnrConn22(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(TreeCnrConn15 * aSource, IMessageBox * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == TreeCnrConn15::exceptionId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : Conn15(exceptionOccurred) to MessageBox(showException))");
         try {target->show(*(IException *) (anEvent.eventData().asUnsignedLong()));}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   TreeCnrConn15 * source;
   IMessageBox * target;


};   //TreeCnrConn22


//*****************************************************************************
// Class definition for TreeCnrConn12
//*****************************************************************************
class TreeCnrConn12 : public IObserver, public IStandardNotifier {
public:
   virtual  ~TreeCnrConn12(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IToolBarButton * aSource, TreeCnr * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };
   TreeCnrConn12 & setACnr(IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj > * aSelf) {iACnr = aSelf; return *this;};
   TreeCnrConn12 & setACol(IVSequence< Person * > * aSelf) {iACol = aSelf; return *this;};
   TreeCnrConn12 & setAPerson(IVBVariablePartPointer<Person *> * aSelf) {iAPerson = aSelf; return *this;};

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IToolBarButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : ToolBarButton4(buttonClickEvent) to Member function->deleteObjectInTreeView())");
         try {target->deleteObjectInTreeView(iACnr, iACol, iAPerson->target());}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IToolBarButton * source;
   TreeCnr * target;
   IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj > * iACnr;
   IVSequence< Person * > * iACol;
   IVBVariablePartPointer<Person *> * iAPerson;


};   //TreeCnrConn12


//*****************************************************************************
// Class definition for TreeCnrConn17
//*****************************************************************************
class TreeCnrConn17 : public IObserver, public IStandardNotifier {
public:
   virtual  ~TreeCnrConn17(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(TreeCnr * aSource, TreeCnr * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == TreeCnr::readyId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : (ready) to (customLogic))");
         try {codeSnippet(&anEvent);}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member functions
   //---------------------------------------------------------------------------
   void codeSnippet(const INotificationEvent* event)
      {
      target->addObjectInTreeView(
        target->iTreeCnr, 
        target->iPeople,
        new Person("Greg Clark", "Root", "444-1902"));
      target->addObjectInTreeView(
        target->iTreeCnr,
        target->iPeople,
        new Person("Peter Spung", "Greg Clark", "444-1647"));
      target->addObjectInTreeView(
        target->iTreeCnr,
        target->iPeople,
        new Person("Jim Doherty", "Peter Spung", "444-1626"));
      target->addObjectInTreeView(
        target->iTreeCnr,
        target->iPeople,
        new Person("Dave Bernath", "Jim Doherty", "444-1567"));
      target->addObjectInTreeView(
        target->iTreeCnr,
        target->iPeople,
        new Person("Kathy Endres", "Jim Doherty", "444-1623"));
      target->addObjectInTreeView(
        target->iTreeCnr,
        target->iPeople,
        new Person("Paul Holmes", "Jim Doherty", "444-1650"));
      target->addObjectInTreeView(
        target->iTreeCnr,
        target->iPeople,
        new Person("Don Ingerslew", "Peter Spung", "444-1651"));
      target->addObjectInTreeView(
        target->iTreeCnr,
        target->iPeople,
        new Person("Bob Love", "Don Ingerslew", "444-1617"));
      target->addObjectInTreeView(
        target->iTreeCnr,
        target->iPeople,
        new Person("Judy Oakley", "Don Ingerslew", "444-1602"));
      target->addObjectInTreeView(
        target->iTreeCnr,
        target->iPeople,
        new Person("Martin Stich", "Don Ingerslew", "444-1630"));
      target->addObjectInTreeView(
        target->iTreeCnr,
        target->iPeople,
        new Person("Mary Streble", "Don Ingerslew", "444-1614"));
      target->addObjectInTreeView(
        target->iTreeCnr,
        target->iPeople,
        new Person("Barry Lee", "Peter Spung", "444-1187"));
      target->addObjectInTreeView(
        target->iTreeCnr,
        target->iPeople,
        new Person("Mark Anderson", "Barry Lee", "444-1656"));
      target->addObjectInTreeView(
        target->iTreeCnr,
        target->iPeople,
        new Person("George DeCandio", "Barry Lee", "444-1569"));
      target->addObjectInTreeView(
        target->iTreeCnr,
        target->iPeople,
        new Person("Venkat Iyer", "Barry Lee", "444-5532"));
      target->addObjectInTreeView(
        target->iTreeCnr,
        target->iPeople,
        new Person("Dave Lavin", "Barry Lee", "444-1619"));
      };

   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   TreeCnr * source;
   TreeCnr * target;


};   //TreeCnrConn17


//*****************************************************************************
// Class definition for TreeCnrConn44
//*****************************************************************************
class TreeCnrConn44 : public IObserver, public IStandardNotifier {
public:
   virtual  ~TreeCnrConn44(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IToolBarButton * aSource, IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj > * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IToolBarButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : ToolBarButton2(buttonClickEvent) to TreeCnr(expandTree))");
         try {target->expandTree();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IToolBarButton * source;
   IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj > * target;


};   //TreeCnrConn44


//*****************************************************************************
// Class definition for TreeCnrConn25
//*****************************************************************************
class TreeCnrConn25 : public IObserver, public IStandardNotifier {
public:
   virtual  ~TreeCnrConn25(){};

   //---------------------------------------------------------------------------
   // public member functions
   //---------------------------------------------------------------------------
   void initialize(IToolBarButton * aSource, IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj > * aTarget)
      {source = aSource; target = aTarget; enableNotification(); };

protected:
   //---------------------------------------------------------------------------
   // protected member functions
   //---------------------------------------------------------------------------
   virtual IObserver & dispatchNotificationEvent(const INotificationEvent & anEvent)
      {
      if (anEvent.notificationId() == IToolBarButton::buttonClickId)
         {
         IFUNCTRACE_DEVELOP();
         ITRACE_DEVELOP(" firing connection : ToolBarButton5(buttonClickEvent) to TreeCnr(collapseTree))");
         try {target->collapseTree();}
         catch (IException& exc) {};
         }
      return(*this);
      };

private:
   //---------------------------------------------------------------------------
   // private member data
   //---------------------------------------------------------------------------
   IToolBarButton * source;
   IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj > * target;


};   //TreeCnrConn25


//------------------------------------------------------------------------------
// TreeCnrTreeCnrCnrObj :: TreeCnrTreeCnrCnrObj
//------------------------------------------------------------------------------
#pragma export (TreeCnrTreeCnrCnrObj::TreeCnrTreeCnrCnrObj(Person&))
TreeCnrTreeCnrCnrObj::TreeCnrTreeCnrCnrObj(Person& anObject)
 :IVBContainerObject(anObject.name(), ISystemPointerHandle(ISystemPointerHandle::warning)),
      phoneNumber(anObject.phoneNumber()), parentName(anObject.parentName()), pRealObject(anObject)
{
   enableDataUpdate();
   handleNotificationsFor(pRealObject);
}


//------------------------------------------------------------------------------
// TreeCnrTreeCnrCnrObj :: TreeCnrTreeCnrCnrObj
//------------------------------------------------------------------------------
#pragma export (TreeCnrTreeCnrCnrObj::TreeCnrTreeCnrCnrObj(TreeCnrTreeCnrCnrObj&))
TreeCnrTreeCnrCnrObj::TreeCnrTreeCnrCnrObj(TreeCnrTreeCnrCnrObj& anObject)
 :IVBContainerObject(anObject.iconText(), anObject.icon()),
      phoneNumber(anObject.phoneNumber), parentName(anObject.parentName), pRealObject(anObject.pRealObject)
{  }


//------------------------------------------------------------------------------
// TreeCnrTreeCnrCnrObj :: ~TreeCnrTreeCnrCnrObj
//------------------------------------------------------------------------------
#pragma export (TreeCnrTreeCnrCnrObj::~TreeCnrTreeCnrCnrObj())
TreeCnrTreeCnrCnrObj::~TreeCnrTreeCnrCnrObj()
{
   this->stopHandlingNotificationsFor(pRealObject);
}


//------------------------------------------------------------------------------
// TreeCnrTreeCnrCnrObj :: refreshFromObject
//------------------------------------------------------------------------------
#pragma export (TreeCnrTreeCnrCnrObj::refreshFromObject())
IVBContainerObject & TreeCnrTreeCnrCnrObj::refreshFromObject()
{
   setIconText(pRealObject.name());
   setIcon(ISystemPointerHandle(ISystemPointerHandle::warning));
   phoneNumber = pRealObject.phoneNumber();
   parentName = pRealObject.parentName();
   return *this;
}


//------------------------------------------------------------------------------
// TreeCnrTreeCnrCnrObj :: updateToObject
//------------------------------------------------------------------------------
IVBContainerObject & TreeCnrTreeCnrCnrObj::updateToObject()
{
   pRealObject.setName(iconText());
   pRealObject.setPhoneNumber(phoneNumber);
   pRealObject.setParentName(parentName);
   return *this;
}


//------------------------------------------------------------------------------
// TreeCnrTreeCnrCnrObj :: operator=
//------------------------------------------------------------------------------
TreeCnrTreeCnrCnrObj& TreeCnrTreeCnrCnrObj::operator=(const TreeCnrTreeCnrCnrObj& anObject)
{
   if (this == &anObject) {
      return *this;
      }
   IVBContainerObject::operator=(anObject);
   phoneNumber = anObject.phoneNumber;
   parentName = anObject.parentName;
   return *this;
}



const INotificationId TreeCnrPersonFactFactory::newObjectCreatedId = "TreeCnrPersonFactFactory::newObjectCreatedId";

//------------------------------------------------------------------------------
// TreeCnrPersonFactFactory :: TreeCnrPersonFactFactory
//------------------------------------------------------------------------------
#pragma export (TreeCnrPersonFactFactory::TreeCnrPersonFactFactory())
TreeCnrPersonFactFactory::TreeCnrPersonFactFactory()
{
   enableNotification();
}

//------------------------------------------------------------------------------
// TreeCnrPersonFactFactory :: ~TreeCnrPersonFactFactory
//------------------------------------------------------------------------------
#pragma export (TreeCnrPersonFactFactory::~TreeCnrPersonFactFactory())
TreeCnrPersonFactFactory::~TreeCnrPersonFactFactory()
{
   disableNotification();
}

//------------------------------------------------------------------------------
// TreeCnrPersonFactFactory :: create
//------------------------------------------------------------------------------
#pragma export (TreeCnrPersonFactFactory::create())
Person * TreeCnrPersonFactFactory::create()
{
   Person *iPersonFact = new Person(iAddEf->text());
   iPersonFact->setParentName(iSelPerson->target()->name());
   iPersonFact->enableNotification();
   notifyObservers(INotificationEvent(newObjectCreatedId, *this, true, IEventData((void *)iPersonFact)));
   return(iPersonFact);
}



#pragma export (TreeCnr::readyId)
const INotificationId TreeCnr::readyId = "TreeCnr::readyId";

//------------------------------------------------------------------------------
// TreeCnr :: defaultFramingSpec
//------------------------------------------------------------------------------
#pragma export (TreeCnr::defaultFramingSpec())
const IRectangle TreeCnr::defaultFramingSpec()
{
   return(IRectangle(IPoint(117, IWindow::desktopWindow()->size().height() - 23 - 274),ISize(617, 274)));
}


//------------------------------------------------------------------------------
// TreeCnr :: defaultTitle
//------------------------------------------------------------------------------
#pragma export (TreeCnr::defaultTitle())
IString TreeCnr::defaultTitle()
{
   return("Company Org Chart");
}


//------------------------------------------------------------------------------
// TreeCnr :: TreeCnr
//------------------------------------------------------------------------------
#pragma export (TreeCnr::TreeCnr(unsigned long, IWindow*, IWindow*, const IRectangle&, const IFrameWindow::Style&, const char*))
TreeCnr::TreeCnr(
      unsigned long id, 
      IWindow* parent, 
      IWindow* owner, 
      const IRectangle& rect, 
      const IFrameWindow::Style& style, 
      const char* title)
   : IFrameWindow(id, parent, owner, rect, style, title)
{
   iMultiCellCanvas1 = new IMultiCellCanvas(
      IC_FRAME_CLIENT_ID, 
      this, 
      this, 
      IRectangle());
   iTreeCnr = new IVBContainerControl< Person*, IVSequence<Person*>, TreeCnrTreeCnrCnrObj >(
      id+WNDOFFSET_TreeCnr_TreeCnr, 
      iMultiCellCanvas1, 
      iMultiCellCanvas1, 
      IRectangle ( ));
   iContainerColumn1 = new IContainerColumn(TreeCnrTreeCnrCnrObj::iconTextOffset(), IContainerColumn::defaultHeadingStyle ( ), (IContainerColumn::defaultDataStyle ( )) & ~IContainerColumn::icon | IContainerColumn::string);
   iContainerColumn2 = new IContainerColumn(offsetof(TreeCnrTreeCnrCnrObj, parentName), IContainerColumn::defaultHeadingStyle ( ), (IContainerColumn::defaultDataStyle ( )) & ~IContainerColumn::icon | IContainerColumn::string);
   iContainerColumn3 = new IContainerColumn(offsetof(TreeCnrTreeCnrCnrObj, phoneNumber), IContainerColumn::defaultHeadingStyle ( ), (IContainerColumn::defaultDataStyle ( )) & ~IContainerColumn::icon | IContainerColumn::string);
   iToolBar1 = new IToolBar(
      id+WNDOFFSET_TreeCnr_ToolBar1, 
      this, 
      IToolBar::aboveClient, 
      false, 
      IToolBar::defaultStyle() & ~IToolBar::buttonBitmapVisible & ~IToolBar::buttonBitmapAndTextVisible | IToolBar::buttonTextVisible);
   iToolBarButton = new IToolBarButton(
      id+WNDOFFSET_TreeCnr_ToolBarButton, 
      iToolBar1, 
      iToolBar1, 
      IRectangle(), 
      IToolBarButton::defaultStyle() | IControl::group);
   iAddEf = new IEntryField(
      id+WNDOFFSET_TreeCnr_AddEf, 
      iToolBar1, 
      iToolBar1, 
      IRectangle(), 
      IEntryField::defaultStyle() & ~IControl::group);
   iToolBarButton4 = new IToolBarButton(
      id+WNDOFFSET_TreeCnr_ToolBarButton4, 
      iToolBar1, 
      iToolBar1, 
      IRectangle(), 
      IToolBarButton::defaultStyle() | IControl::group);
   iToolBarButton3 = new IToolBarButton(
      id+WNDOFFSET_TreeCnr_ToolBarButton3, 
      iToolBar1, 
      iToolBar1, 
      IRectangle(), 
      IToolBarButton::defaultStyle() | ICustomButton::autoLatch | IControl::group);
   iToolBarButton1 = new IToolBarButton(
      id+WNDOFFSET_TreeCnr_ToolBarButton1, 
      iToolBar1, 
      iToolBar1, 
      IRectangle(), 
      IToolBarButton::defaultStyle() & ~IControl::group | ICustomButton::autoLatch);
   iToolBarButton2 = new IToolBarButton(
      id+WNDOFFSET_TreeCnr_ToolBarButton2, 
      iToolBar1, 
      iToolBar1, 
      IRectangle(), 
      IToolBarButton::defaultStyle() | IControl::group);
   iToolBarButton5 = new IToolBarButton(
      id+WNDOFFSET_TreeCnr_ToolBarButton5, 
      iToolBar1, 
      iToolBar1, 
      IRectangle(), 
      IToolBarButton::defaultStyle() & ~IControl::group);
   iInfoArea1 = new IInfoArea(this, id+WNDOFFSET_TreeCnr_InfoArea1);
   iPeople = new IVSequence< Person * >();
   iPersonFact = new TreeCnrPersonFactFactory();
   iSelPerson = new IVBVariablePartPointer<Person *>();
   iMessageBox = new IMessageBox(this);

   conn7 = new TreeCnrConn7();
   conn9 = new TreeCnrConn9();
   conn18 = new TreeCnrConn18();
   conn29 = new TreeCnrConn29();
   conn14 = new TreeCnrConn14();
   conn15 = new TreeCnrConn15();
   conn22 = new TreeCnrConn22();
   conn12 = new TreeCnrConn12();
   conn17 = new TreeCnrConn17();
   conn44 = new TreeCnrConn44();
   conn25 = new TreeCnrConn25();

   iMultiCellCanvas1->addToCell(iTreeCnr, 1, 1, 1, 1);
   iMultiCellCanvas1->setColumnWidth(1, IMultiCellCanvas::defaultCell().width(), true);
   iMultiCellCanvas1->setRowHeight(1, IMultiCellCanvas::defaultCell().height(), true);
   iTreeCnr->showTitleSeparator(true);
   iTreeCnr->showTreeTextView();
   iTreeCnr->addColumn(iContainerColumn1);
   iTreeCnr->addColumn(iContainerColumn2);
   iTreeCnr->addColumn(iContainerColumn3);
   iContainerColumn1->setHeadingText("Name");
   iContainerColumn2->setHeadingText("Boss's name");
   iContainerColumn3->setHeadingText("Phone #");
   iToolBar1->addAsLast(iToolBarButton, iToolBarButton->isGroup());
   iToolBar1->addAsLast(iAddEf, iAddEf->isGroup());
   iToolBar1->addAsLast(iToolBarButton4, iToolBarButton4->isGroup());
   iToolBar1->addAsLast(iToolBarButton3, iToolBarButton3->isGroup());
   iToolBar1->addAsLast(iToolBarButton1, iToolBarButton1->isGroup());
   iToolBar1->addAsLast(iToolBarButton2, iToolBarButton2->isGroup());
   iToolBar1->addAsLast(iToolBarButton5, iToolBarButton5->isGroup());
   iToolBarButton->setText("Add");
   iAddEf->setMinimumSize(ISize(157, 27));
   iToolBarButton4->setText("Delete");
   iToolBarButton3->setText("TreeTxt");
   iToolBarButton3->latch(true);
   iToolBarButton1->setText("Tree");
   iToolBarButton1->latch(false);
   iToolBarButton2->setText("Expand");
   iToolBarButton5->setText("Collapse");
   this->setFocus();
   this->setClient(iMultiCellCanvas1);
   iPeople->add(new Person("Root"));
   iPersonFact->setAddEf(iAddEf);
   iPersonFact->setSelPerson(iSelPerson);
}     //end constructor


//------------------------------------------------------------------------------
// TreeCnr :: ~TreeCnr
//------------------------------------------------------------------------------
#pragma export (TreeCnr::~TreeCnr())
TreeCnr::~TreeCnr()
{
   conn7->stopHandlingNotificationsFor(*iToolBarButton1);
   conn9->stopHandlingNotificationsFor(*iPeople);
   conn9->stopHandlingNotificationsFor(*iTreeCnr);
   conn18->stopHandlingNotificationsFor(*iSelPerson);
   conn29->stopHandlingNotificationsFor(*iTreeCnr);
   conn29->stopHandlingNotificationsFor(*iSelPerson);
   conn14->stopHandlingNotificationsFor(*iToolBarButton3);
   conn15->stopHandlingNotificationsFor(*iToolBarButton);
   conn22->stopHandlingNotificationsFor(*conn15);
   conn12->stopHandlingNotificationsFor(*iToolBarButton4);
   conn17->stopHandlingNotificationsFor(*this);
   conn44->stopHandlingNotificationsFor(*iToolBarButton2);
   conn25->stopHandlingNotificationsFor(*iToolBarButton5);

   delete conn7;
   delete conn9;
   delete conn18;
   delete conn29;
   delete conn14;
   delete conn15;
   delete conn22;
   delete conn12;
   delete conn17;
   delete conn44;
   delete conn25;


   delete iMultiCellCanvas1;
   delete iTreeCnr;
   delete iContainerColumn1;
   delete iContainerColumn2;
   delete iContainerColumn3;
   delete iToolBar1;
   delete iToolBarButton;
   delete iAddEf;
   delete iToolBarButton4;
   delete iToolBarButton3;
   delete iToolBarButton1;
   delete iToolBarButton2;
   delete iToolBarButton5;
   delete iInfoArea1;
   delete iPeople;
   delete iPersonFact;
   delete iSelPerson;
   delete iMessageBox;
}

//------------------------------------------------------------------------------
// TreeCnr :: initializePart
//------------------------------------------------------------------------------
#pragma export (TreeCnr::initializePart())
TreeCnr & TreeCnr::initializePart()
{
   makeConnections();
   notifyObservers(INotificationEvent(readyId, *this));
   return *this;
}


//------------------------------------------------------------------------------
// TreeCnr :: makeConnections
//------------------------------------------------------------------------------
#pragma export (TreeCnr::makeConnections())
Boolean TreeCnr::makeConnections()
{
   this->enableNotification();
   iMultiCellCanvas1->enableNotification();
   iTreeCnr->enableNotification();
   iToolBar1->enableNotification();
   iToolBarButton->enableNotification();
   iAddEf->enableNotification();
   iToolBarButton4->enableNotification();
   iToolBarButton3->enableNotification();
   iToolBarButton1->enableNotification();
   iToolBarButton2->enableNotification();
   iToolBarButton5->enableNotification();
   iInfoArea1->enableNotification();
   iPeople->enableNotification();
   iPersonFact->enableNotification();
   iSelPerson->enableNotification();

   unsigned long id = this->id();
   conn7->initialize(iToolBarButton1, iTreeCnr);
   conn7->handleNotificationsFor(*iToolBarButton1);
   conn9->initialize(iPeople, iTreeCnr);
   conn9->handleNotificationsFor(*iPeople);
   conn9->handleNotificationsFor(*iTreeCnr);
   conn18->initialize(iSelPerson, iInfoArea1);
   conn18->handleNotificationsFor(*iSelPerson);
   conn29->initialize(iTreeCnr, iSelPerson);
   conn29->handleNotificationsFor(*iTreeCnr);
   conn29->handleNotificationsFor(*iSelPerson);
   conn14->initialize(iToolBarButton3, iTreeCnr);
   conn14->handleNotificationsFor(*iToolBarButton3);
   conn15->initialize(iToolBarButton, this);
   conn15->handleNotificationsFor(*iToolBarButton);
   conn22->initialize(conn15, iMessageBox);
   conn22->handleNotificationsFor(*conn15);
   conn12->initialize(iToolBarButton4, this);
   conn12->handleNotificationsFor(*iToolBarButton4);
   conn12->setACnr(iTreeCnr);
   conn12->setACol(iPeople);
   conn12->setAPerson(iSelPerson);
   conn17->initialize(this, this);
   conn17->handleNotificationsFor(*this);
   conn44->initialize(iToolBarButton2, iTreeCnr);
   conn44->handleNotificationsFor(*iToolBarButton2);
   conn25->initialize(iToolBarButton5, iTreeCnr);
   conn25->handleNotificationsFor(*iToolBarButton5);

   conn9->setTarget();
   conn29->setTarget();
   return true;
}



#include "treecnr.cpv"
