/* toolkit.cmd */
/* This is the program installation profile for the 1.1 toolkit */
SET FAPI=0
SET DISK2=0
SET BSE_C=0
SET BSE_MASM=0
SET CEE=0
SET MASM=0
SET PM=0
SET PM_C=0
SET PM_C_INC=0
SET BSE_CINC=0
SET PM_MASM=0
SET PM_M_INC=0
SET BSE_MINC=0
SET DISP_LNK=0
SET JUMPBACK=0
SET NOSPACE=0
SET MSLSH=0
SET CSLSH=0


SET csampath=\toolkt11\c\samples\bse\csampath.cmd
SET msampath=\toolkt11\masm\samples\bse\msampath.cmd
SET pmcpath=\toolkt11\c\samples\pm\pmpath.cmd
SET pmmpath=\toolkt11\masm\samples\pm\pmpathm.cmd

set logfile=a:log

LIBRARY    %SD%TOOLKIT.LIB

HINDEX TKINDEX.PAN

/*--------------------------------------------------------------------------*
 * Display Logo                                                             *
 *--------------------------------------------------------------------------*/

  COPY %SD%\TOOLKIT.LIB C:\OS2\TOOLKIT.LIB >NUL  /* Copy library */
  COPY %SD%\BIN\UNPACK.EXE C:\OS2 >NUL           /* Copy unpack  */
  LIBRARY /D %SD%TOOLKIT.LIB
  LIBRARY c:\OS2\TOOLKIT.LIB                     /* switch to td library */

:DISPLAY_LOGO
  DISPLAY  TKLOGO  ESC  ENTER
  SELECT %RETURN%
    WHEN ESC GOTO ABEND
  ESELECT

/*--------------------------------------------------------------------------*
 * Display Welcome                                                          *
 *--------------------------------------------------------------------------*/
:DISPLAY_WELCOME
  DISPLAY TKWEL ESC ENTER HELP F3
  SELECT %RETURN%
    WHEN ESC GOTO DISPLAY_LOGO
    WHEN F3 CALL EXIT_ONE
            GOTO DISPLAY_WELCOME
  ESELECT

/*--------------------------------------------------------------------------*
 * Display Main Panel                                                       *
 *--------------------------------------------------------------------------*/
:DISPLAY_MENU
  DISPLAY TKMAINM ESC ENTER HELP F3
  SELECT %RETURN%
    WHEN ESC GOTO DISPLAY_WELCOME
    WHEN F3 CALL EXIT_ONE
            GOTO DISPLAY_MENU
  ESELECT

/*--------------------------------------------------------------------------*
 * Identify Target Drive                                                    *
 *--------------------------------------------------------------------------*/
:DETERMINE_TD
  DT C:                         /* Identifies the target drive */
:SELECT_DRIVE
  DT?                           /* Display target drive entry panel */
  SELECT %RC%
    WHEN 1 GOTO DISPLAY_MENU    /* Return to previous panel */
  ESELECT
  SELECT %TD%                   /* What drive was selected? */
    WHEN A: GOTO HARD_FILE
    WHEN B: GOTO HARD_FILE
    OTHERWISE GOTO CDRIVE
  ESELECT

:HARD_FILE
  DISPLAY TKDISK ESC ENTER HELP /* Error msg for drive selection */
  SELECT %RETURN%
    WHEN F3 CALL EXIT_ONE
            GOTO HARD_FILE
  ESELECT
  GOTO DETERMINE_TD             /* Return to select drive */

/*--------------------------------------------------------------------------*
 * Space Available to Install?                                              *
 *--------------------------------------------------------------------------*/
:CDRIVE
  DS %TD% 3200000
  SELECT %RC%
    WHEN 1 DISPLAY TKSPACE ESC ENTER HELP F3
  ESELECT
  SELECT %RETURN%
    WHEN ESC GOTO DETERMINE_TD
    WHEN F3 CALL EXIT_ONE
            GOTO CDRIVE
  ESELECT

/*--------------------------------------------------------------------------*
 * Was Toolkit previously installed?                                        *
 *--------------------------------------------------------------------------*/
 :ALREADY
  VF %TD%\toolkt11\bin\implib.exe
  SELECT %RC%
    WHEN 1 GOTO DISPLAY_FAM_API
  ESELECT
  DISPLAY TKINST ESC ENTER HELP
  SELECT %RETURN%
    WHEN ESC GOTO SELECT_DRIVE
  ESELECT
  SELECT %CHOICE%
    WHEN 2 CALL EXIT_ONE
           GOTO ALREADY
  ESELECT

/*--------------------------------------------------------------------------*
 * Remove MASM samples titles                                               *
 *--------------------------------------------------------------------------*/
  AIF    /D
  TITLE  Hello World MASM Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  Family API MASM Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  DOS Stub MASM Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  Dynamic Link MASM Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  Memory Allocation MASM Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  Processes MASM Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  Threads MASM Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  Keyboard and VIO MASM Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  Privilege Level 2 MASM Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  Critical Error MASM Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  World Trade API MASM Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  Mouse Support MASM Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  Device Driver MASM Sample
  GROUP
  EAIF

/*--------------------------------------------------------------------------*
 * Remove C samples titles from main group                                  *
 *--------------------------------------------------------------------------*/
:CHK_C_INST
  AIF    /D
  TITLE  Hello World C Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  Family API C Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  Dynamic Link C Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  Memory Allocation C Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  Keyboard and VIO C Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  Critical Error C Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  World Trade API C Sample
  GROUP
  EAIF
  AIF    /D
  TITLE  Mouse Support C Sample
  GROUP
  EAIF

/*--------------------------------------------------------------------------*
 * Display Family API Panel (FAPI)                                          *
 *--------------------------------------------------------------------------*/
:DISPLAY_FAM_API
  DISPLAY TKAPI ESC ENTER HELP F3
  SELECT %RETURN%
    WHEN ESC GOTO DETERMINE_TD
    WHEN F3 CALL EXIT_ONE
            GOTO DISPLAY_FAM_API
  ESELECT
  SELECT %CHOICE%
    WHEN 1 SET FAPI=1
    WHEN 2 SET FAPI=0
  ESELECT

/*--------------------------------------------------------------------------*
 * Display MASM Sample Program Panel (BSE_MASM)                             *
 *--------------------------------------------------------------------------*/
:DISPLAY_MASM
  DISPLAY TKMASM ESC ENTER HELP F3
  SELECT %RETURN%
    WHEN ESC GOTO DISPLAY_FAM_API
    WHEN F3 CALL EXIT_ONE
            GOTO DISPLAY_MASM
  ESELECT
  SELECT %CHOICE%
    WHEN 1  SET BSE_MASM=1
    WHEN 2  SET BSE_MASM=0
  ESELECT

/*--------------------------------------------------------------------------*
 * Display C Sample Program Panel (BSE_C)                                   *
 *--------------------------------------------------------------------------*/
:DISPLAY_C
  DISPLAY TKC ESC ENTER HELP F3
  SELECT %RETURN%
    WHEN ESC GOTO DISPLAY_MASM
    WHEN F3 CALL EXIT_ONE
            GOTO DISPLAY_C
  ESELECT
  SELECT %CHOICE%
    WHEN 1 SET BSE_C=1
    WHEN 2 SET BSE_C=0
  ESELECT

/*--------------------------------------------------------------------------*
 * Display Presentation Manager Utilities Panel (PM)                        *
 *--------------------------------------------------------------------------*/
:DISPLAY_PRES_MGR
  DISPLAY TKPM ESC ENTER HELP F3
  SELECT %RETURN%
    WHEN ESC GOTO DISPLAY_C
    WHEN F3 CALL EXIT_ONE
            GOTO DISPLAY_PRES_MGR
  ESELECT
  SELECT %CHOICE%
    WHEN 1 SET PM=1
    WHEN 2 SET PM=0
  ESELECT

/*--------------------------------------------------------------------------*
 * Display Presentation Manager MASM Sample Programs Panel (PM_MASM)        *
 *--------------------------------------------------------------------------*/
:DISPLAY_PM_MASM
  DISPLAY TKPMASM ESC ENTER HELP F3
  SELECT %RETURN%
    WHEN ESC GOTO DISPLAY_PRES_MGR
    WHEN F3  CALL EXIT_ONE
             GOTO DISPLAY_PM_MASM
  ESELECT
  SELECT %CHOICE%
    WHEN 1 SET PM_MASM=1
    WHEN 2 SET PM_MASM=0
  ESELECT

/*--------------------------------------------------------------------------*
 * Display Presentation Manager C Sample Programs Panel (PM_C)              *
 *--------------------------------------------------------------------------*/
:DISPLAY_PM_C
  DISPLAY TKPC ESC ENTER HELP F3
  SELECT %RETURN%
    WHEN ESC GOTO DISPLAY_PM_MASM
    WHEN F3  CALL EXIT_ONE
             GOTO DISPLAY_PM_C
  ESELECT
  SELECT %CHOICE%
    WHEN 1 SET PM_C=1
    WHEN 2 SET PM_C=0
  ESELECT

/*--------------------------------------------------------------------------*
 * Make sure linker is installed                                            *
 *--------------------------------------------------------------------------*/
:LINKER_CHECK
  VF C:\OS2\LINK.EXE
  SELECT %RC%
    WHEN 1 SET DISP_LNK=1
  ESELECT
  VF C:\OS2\DOSCALLS.LIB
  SELECT %RC%
    WHEN 1 SET DISP_LNK=1
  ESELECT
  SELECT %DISP_LNK%
    WHEN 0 GOTO WHAT_TO_INSTALL
  ESELECT

:DISPLAY_LINK
  DISPLAY TKLINKR ESC ENTER HELP F3
  SELECT %RETURN%
    WHEN ESC GOTO DISPLAY_PM_C
    WHEN F3 CALL EXIT_ONE
            GOTO DISPLAY_LINK
  ESELECT
  VF %SD%LINK.EX@  IBM Operating System/2 Diskette 2
  SELECT %RC%
    WHEN 1 GOTO DISPLAY_LINK
  ESELECT
  UNPACK %SD%LINK.EX@ C:\OS2 >NUL
  UNPACK %SD%DOSCALLS.LI@ C:\OS2 >NUL
  SET DISP_LNK=0
:DISK_1
  VF %SD%TOOLKIT.PIP  IBM Operating System/2 Toolkit and Sample Programs Disk 1
  SELECT %RC%
    WHEN 1 CALL EXIT_ONE
           GOTO LINKER_CHECK
  ESELECT

/*--------------------------------------------------------------------------*
 * Where is C and MASM installed?                                           *
 *--------------------------------------------------------------------------*/
:WHAT_TO_INSTALL
SET DISK2=0
SET CEE=0
SET MASM=0
SET PM_C_INC=0
SET BSE_CINC=0
SET PM_M_INC=0
SET BSE_MINC=0

 SELECT %PM%
   WHEN 1 SET DISK2=1
 ESELECT
 SELECT %BSE_MASM%
   WHEN 1 SET MASM=1
          SET BSE_MINC=1
          SET PM_M_INC=1
          SET DISK2=1
 ESELECT
 SELECT %PM_MASM%
   WHEN 1 SET MASM=1
          SET PM=1
          SET BSE_MINC=1
          SET PM_M_INC=1
          SET DISK2=1
 ESELECT
 SELECT %BSE_C%
   WHEN 1 SET CEE=1
          SET BSE_CINC=1
          SET PM_C_INC=1
          SET DISK2=1
 ESELECT
 SELECT %PM_C%
   WHEN 1 SET CEE=1
          SET PM=1
          SET BSE_CINC=1
          SET PM_C_INC=1
          SET DISK2=1
 ESELECT


:WHERE_MASM

 SELECT %MASM%
   WHEN 0 GOTO WHERE_C
 ESELECT
 SET MMainDir=C:\MASM
 SET MBin=BIN
 DISPLAY TKMDIR ENTER ESC HELP F3
 SELECT %RETURN%
   WHEN ESC GOTO DISPLAY_PM_C
   WHEN F3 CALL EXIT_ONE
           GOTO WHERE_MASM
 ESELECT
 VF %MMainDir%\%MBin%
 SELECT %RC%
   WHEN 0 GOTO WHERE_C
 ESELECT
 VF %MMainDir%%MBin%
 SELECT %RC%
   WHEN 0 SET MSLSH=1
          GOTO WHERE_C
   WHEN 1 DISPLAY TKXDIR ESC ENTER HELP
 ESELECT
 SELECT %RETURN%
   WHEN ESC GOTO WHERE_MASM
 ESELECT
 SELECT %CHOICE%
   WHEN 2 GOTO WHERE_MASM
 ESELECT
 GOTO WHERE_C

:JUMPBACK
 SELECT %MASM%
   WHEN 0 GOTO DISPLAY_PM_C
   WHEN 1 GOTO WHERE_MASM
 ESELECT

:WHERE_C
 SELECT %CEE%
   WHEN 0 GOTO START_INSTALL
 ESELECT
 SET CMainDir=C:\C
 SET CBin=BIN
 SET CInc=INCLUDE
 SET CLib=LIB
 DISPLAY TKCDIR ENTER ESC HELP F3
 SELECT %RETURN%
   WHEN ESC GOTO JUMPBACK
   WHEN F3 CALL EXIT_ONE
           GOTO WHERE_C
 ESELECT

:WHERE_C_BIN
 VF %CMainDir%\%CBin%
 SELECT %RC%
   WHEN 0 GOTO WHERE_C_LIB
 ESELECT
 VF %CMainDir%%CBin%
 SELECT %RC%
   WHEN 0 SET CSLSH=1
          GOTO WHERE_C_LIB
   WHEN 1 DISPLAY TKXDIR ENTER ESC HELP
 ESELECT
 SELECT %RETURN%
   WHEN ESC GOTO WHERE_C
 ESELECT
 SELECT %CHOICE%
   WHEN 1 GOTO START_INSTALL
   WHEN 2 GOTO WHERE_C
 ESELECT

:WHERE_C_LIB
 SELECT %CSLSH%
   WHEN 0    VF %CMainDir%\%CLib%
   OTHERWISE VF %CMainDir%%CLib%
 ESELECT
 SELECT %RC%
   WHEN 0 GOTO WHERE_C_INC
   WHEN 1 DISPLAY TKXDIR ENTER ESC HELP
 ESELECT
 SELECT %RETURN%
   WHEN ESC GOTO WHERE_C
 ESELECT
 SELECT %CHOICE%
   WHEN 1 GOTO START_INSTALL
   WHEN 2 GOTO WHERE_C
 ESELECT

:WHERE_C_INC
 SELECT %CSLSH%
   WHEN 0    VF %CMainDir%\%CInc%
   OTHERWISE VF %CMainDir%%CInc%
 ESELECT
 SELECT %RC%
   WHEN 0 GOTO START_INSTALL
   WHEN 1 DISPLAY TKXDIR ENTER ESC HELP
          GOTO WHERE_C
 ESELECT
 SELECT %RETURN%
   WHEN ESC GOTO WHERE_C
 ESELECT
 SELECT %CHOICE%
   WHEN 2 GOTO WHERE_C
 ESELECT

/*--------------------------------------------------------------------------*
 * Diskette 1                                                               *
 *--------------------------------------------------------------------------*/
:START_INSTALL                          /* Verify correct diskette */
  VF %SD%TOOLKIT.PIP  IBM Operating System/2 Toolkit and Sample Programs Disk 1
  SELECT %RC%
    WHEN 1 CALL EXIT_ONE
           GOTO START_INSTALL
  ESELECT

  DISPLAY TKCOPY1
  MD %TD%\TOOLKT11               2>NUL               /* Set up directories  */

  VF %TD%\TOOLKT11\SYSLEVEL.TLK                /* Allow access to syslevel  */
  SELECT %RC%
     WHEN 0 ATTRIB -R %TD%\TOOLKT11\SYSLEVEL.TLK
  ESELECT
  COPY %SD%\SYSLEVEL.TLK %TD%\TOOLKT11 >NUL  /* put new syslevel on disk  */
  ATTRIB +R %TD%\TOOLKT11\SYSLEVEL.TLK

/*--------------------------------------------------------------------------*
 * Install base tools                                                       *
 *--------------------------------------------------------------------------*/
  MD %TD%\TOOLKT11\BIN            2>NUL
  UNPACK %SD%\BIN\IMPLIB.EX@ %TD%\TOOLKT11\BIN >NUL
  UNPACK %SD%\BIN\MKMSGF.EX@ %TD%\TOOLKT11\BIN >NUL
  UNPACK %SD%\BIN\MSGBIND.EX@ %TD%\TOOLKT11\BIN >NUL
  UNPACK %SD%\BIN\WINABLE.EX@ %TD%\TOOLKT11\BIN >NUL

/*--------------------------------------------------------------------------*
 * Install FAPI                                                             *
 *--------------------------------------------------------------------------*/
:INSTALL_FAPI
  SELECT %FAPI%
    WHEN 0 GOTO INSTALL_BSE_MINC
  ESELECT
  VF %SD%TOOLKIT.PIP  IBM Operating System/2 Toolkit and Sample Programs Disk 1
  SELECT %RC%
    WHEN 1 CALL EXIT_ONE
           GOTO INSTALL_FAPI
  ESELECT
  MD %TD%\TOOLKT11\LIB  2>NUL
  UNPACK %SD%\BIN\BIND.EX@ %TD%\TOOLKT11\BIN >NUL
  UNPACK %SD%\LIB\*.* %TD%\TOOLKT11\LIB >NUL

/*--------------------------------------------------------------------------*
 * Install base MASM includes                                               *
 *--------------------------------------------------------------------------*/
:INSTALL_BSE_MINC
  SELECT %BSE_MINC%
    WHEN 0 GOTO INSTALL_BSE_CINC
  ESELECT
  VF %SD%TOOLKIT.PIP  IBM Operating System/2 Toolkit and Sample Programs Disk 1
  SELECT %RC%
    WHEN 1 CALL EXIT_ONE
           GOTO INSTALL_BSE_MINC
  ESELECT
  MD %TD%\TOOLKT11\MASM 2>NUL
  UNPACK %SD%\MASM\README.AS@ %TD%\TOOLKT11\MASM >NUL
  HISTORY %TD%\TOOLKT11\MASM\README.ASM
  MD %TD%\TOOLKT11\MASM\INCLUDE 2>NUL
  UNPACK %SD%\MASM\INCLUDE\*.* %TD%\TOOLKT11\MASM\INCLUDE >NUL
  HISTORY %TD%\TOOLKT11\MASM\INCLUDE\*.*

/*--------------------------------------------------------------------------*
 * Install base C includes                                                  *
 *--------------------------------------------------------------------------*/
:INSTALL_BSE_CINC
  SELECT %BSE_CINC%
    WHEN 0 GOTO INSTALL_BSE_MASM
  ESELECT
  VF %SD%TOOLKIT.PIP  IBM Operating System/2 Toolkit and Sample Programs Disk 1
  SELECT %RC%
    WHEN 1 CALL EXIT_ONE
           GOTO INSTALL_BSE_CINC
  ESELECT
  MD %TD%\TOOLKT11\C 2>NUL
  UNPACK %SD%\C\README.C_@ %TD%\TOOLKT11\C >NUL
  HISTORY %TD%\TOOLKT11\C\README.C
  MD %TD%\TOOLKT11\C\INCLUDE 2>NUL
  UNPACK %SD%\C\INCLUDE\*.* %TD%\TOOLKT11\C\INCLUDE >NUL
  HISTORY %TD%\TOOLKT11\C\INCLUDE\*.*

/*--------------------------------------------------------------------------*
 * Install base MASM samples                                                *
 *--------------------------------------------------------------------------*/
:INSTALL_BSE_MASM
  SELECT %BSE_MASM%
    WHEN 0 GOTO INSTALL_BSE_C
  ESELECT
  VF %SD%TOOLKIT.PIP  IBM Operating System/2 Toolkit and Sample Programs Disk 1
  SELECT %RC%
    WHEN 1 CALL EXIT_ONE
           GOTO INSTALL_BSE_MASM
  ESELECT
  MD %TD%\TOOLKT11\MASM\SAMPLES 2>NUL
  MD %TD%\TOOLKT11\MASM\SAMPLES\BSE 2>NUL
  UNPACK %SD%\MASM\SAMPLES\*.* %TD%\TOOLKT11\MASM\SAMPLES\BSE >NUL

  SELECT %MSLSH%
    WHEN 0    ECHO path c:\os2;%MMainDir%\%MBin%;%TD%\toolkt11\bin>> %TD%%msampath%
    OTHERWISE ECHO path c:\os2;%MMainDir%%MBin%;%TD%\toolkt11\bin>> %TD%%msampath%
  ESELECT
  ECHO set lib=c:\os2>> %TD%%msampath%
  ECHO %TD%>> %TD%%msampath%
  ECHO cd \toolkt11\masm\samples\bse>> %TD%%msampath%

/*--------------------------------------------------------------------------*
 * Install base C samples                                                   *
 *--------------------------------------------------------------------------*/
:INSTALL_BSE_C
  SELECT %BSE_C%
    WHEN 0 GOTO INSTALL_PM_TOOLS
  ESELECT
  VF %SD%TOOLKIT.PIP  IBM Operating System/2 Toolkit and Sample Programs Disk 1
  SELECT %RC%
    WHEN 1 CALL EXIT_ONE
           GOTO INSTALL_BSE_C
  ESELECT
  MD %TD%\TOOLKT11\C\SAMPLES 2>NUL
  MD %TD%\TOOLKT11\C\SAMPLES\BSE 2>NUL
  UNPACK %SD%\C\SAMPLES\*.* %TD%\TOOLKT11\C\SAMPLES\BSE >NUL

  SELECT %CSLSH%
    WHEN 0    ECHO path c:\os2;%CMainDir%\%CBin%;%TD%\toolkt11\c\samples\bse;%TD%\toolkt11\bin>> %TD%%csampath%
              ECHO set lib=%CMainDir%\%CLib%;c:\os2>> %TD%%csampath%
              ECHO set include=%CMainDir%\%CInc%;%TD%\toolkt11\c\include>> %TD%%csampath%
    OTHERWISE ECHO path c:\os2;%CMainDir%%CBin%;%TD%\toolkt11\c\samples\bse;%TD%\toolkt11\bin>> %TD%%csampath%
              ECHO set lib=%CMainDir%%CLib%;c:\os2>> %TD%%csampath%
              ECHO set include=%CMainDir%%CInc%;%TD%\toolkt11\c\include>> %TD%%csampath%
  ESELECT
  MD   %CMainDir%\tmp 2>NUL
  ECHO set tmp=%CMainDir%\tmp>> %TD%%csampath%
  ECHO %TD%>> %TD%%csampath%
  ECHO cd \toolkt11\c\samples\bse>> %TD%%csampath%

/*--------------------------------------------------------------------------*
 * Diskette 2                                                               *
 *--------------------------------------------------------------------------*/
:INSTALL_PM_TOOLS
  SELECT %DISK2%
    WHEN 0 GOTO HISTORY
  ESELECT
  DISPLAY TK1TO2 ENTER ESC HELP F3
  SELECT %RETURN%
    WHEN F3 CALL EXIT_ONE
            GOTO INSTALL_PM_TOOLS
  ESELECT
  VF %SD%\BIN\RC.EX@  IBM Operating System/2 Toolkit and Sample Programs Disk 2
  SELECT %RC%
    WHEN 1 GOTO INSTALL_PM_TOOLS
  ESELECT
  DISPLAY TKCOPY2
  SELECT %PM%
    WHEN 1 UNPACK %SD%\BIN\*.* %TD%\TOOLKT11\BIN >NUL
           MD %TD%\TOOLKT11\LIB 2>NUL
           UNPACK %SD%\LIB\*.* %TD%\TOOLKT11\LIB >NUL
  ESELECT

/*--------------------------------------------------------------------------*
 * Install PM MASM includes                                                 *
 *--------------------------------------------------------------------------*/
:INST_PM_MASM_INC
  SELECT %PM_M_INC%
    WHEN 1 MD %TD%\TOOLKT11\MASM 2>NUL
           MD %TD%\TOOLKT11\MASM\INCLUDE 2>NUL
           MD %TD%\TOOLKT11\MASM\SAMPLES 2>NUL
           UNPACK %SD%\INCLUDE\MASM\*.*  %TD%\TOOLKT11\MASM\INCLUDE >NUL
           HISTORY %TD%\TOOLKT11\MASM\INCLUDE\*.*
  ESELECT

/*--------------------------------------------------------------------------*
 * Install PM C includes                                                    *
 *--------------------------------------------------------------------------*/
:INSTALL_PM_C_INC
  SELECT %PM_C_INC%
    WHEN 1  MD %TD%\TOOLKT11\C 2>NUL
            MD %TD%\TOOLKT11\C\INCLUDE 2>NUL
            MD %TD%\TOOLKT11\C\SAMPLES 2>NUL
            UNPACK %SD%\INCLUDE\C\*.*  %TD%\TOOLKT11\C\INCLUDE >NUL
            HISTORY %TD%\TOOLKT11\C\INCLUDE\*.*
  ESELECT

/*--------------------------------------------------------------------------*
 * Diskette 3                                                               *
 *--------------------------------------------------------------------------*/
:INSTALL_DISK3
  SELECT %PM%
    WHEN 0 GOTO HISTORY
  ESELECT

/*--------------------------------------------------------------------------*
 * Install PM MASM samples                                                  *
 *--------------------------------------------------------------------------*/
:INSTALL_PM_MASM
  SELECT %PM_MASM%
    WHEN 0 GOTO INSTALL_PM_C
  ESELECT
  MD %TD%\TOOLKT11\MASM\SAMPLES\PM 2>NUL
  UNPACK %SD%\MASM\SAMPLES\*.* %TD%\TOOLKT11\MASM\SAMPLES\PM >NUL /*pmpathm.cmd*/
  MD %TD%\TOOLKT11\MASM\SAMPLES\PM\HELLOm 2>NUL
  UNPACK %SD%\MASM\SAMPLES\HELLOm\*.* %TD%\TOOLKT11\MASM\SAMPLES\PM\HELLOm >NUL

  SELECT %MSLSH%
    WHEN 0    ECHO path c:\os2;%MMainDir%\%MBin%;%TD%\toolkt11\bin>> %TD%%pmmpath%
    OTHERWISE ECHO path c:\os2;%MMainDir%%MBin%;%TD%\toolkt11\bin>> %TD%%pmmpath%
  ESELECT
  ECHO set include=%TD%\toolkt11\masm\include>> %TD%%pmmpath%
  ECHO set lib=c:\os2;%TD%\toolkt11\lib>> %TD%%pmmpath%
  ECHO %TD%>> %TD%%pmmpath%
  ECHO cd \toolkt11\masm\samples\pm>> %TD%%pmmpath%

/*--------------------------------------------------------------------------*
 * Install PM C samples                                                     *
 *--------------------------------------------------------------------------*/
:INSTALL_PM_C
  SELECT %PM_C%
    WHEN 0 GOTO HISTORY
  ESELECT
  MD %TD%\TOOLKT11\C\SAMPLES\PM 2>NUL
  UNPACK %SD%\C\SAMPLES\*.* %TD%\TOOLKT11\C\SAMPLES\PM >NUL  /* copy pmpath.cmd */
  MD %TD%\TOOLKT11\C\SAMPLES\PM\AVIOsamp 2>NUL
  UNPACK %SD%\C\SAMPLES\AVIOsamp\*.* %TD%\TOOLKT11\C\SAMPLES\PM\AVIOsamp >NUL
  MD %TD%\TOOLKT11\C\SAMPLES\PM\BMAP 2>NUL
  UNPACK %SD%\C\SAMPLES\BMAP\*.* %TD%\TOOLKT11\C\SAMPLES\PM\BMAP >NUL
  MD %TD%\TOOLKT11\C\SAMPLES\PM\CLIPBRD 2>NUL
  UNPACK %SD%\C\SAMPLES\CLIPBRD\*.* %TD%\TOOLKT11\C\SAMPLES\PM\CLIPBRD >NUL
  MD %TD%\TOOLKT11\C\SAMPLES\PM\Dialog1 2>NUL
  UNPACK %SD%\C\SAMPLES\Dialog1\*.* %TD%\TOOLKT11\C\SAMPLES\PM\Dialog1 >NUL
  MD %TD%\TOOLKT11\C\SAMPLES\PM\Dialog2 2>NUL
  UNPACK %SD%\C\SAMPLES\Dialog2\*.* %TD%\TOOLKT11\C\SAMPLES\PM\Dialog2 >NUL
  MD %TD%\TOOLKT11\C\SAMPLES\PM\FONTTEST 2>NUL
  UNPACK %SD%\C\SAMPLES\FONTTEST\*.* %TD%\TOOLKT11\C\SAMPLES\PM\FONTTEST >NUL
  MD %TD%\TOOLKT11\C\SAMPLES\PM\GRAPHIC1 2>NUL
  UNPACK %SD%\C\SAMPLES\GRAPHIC1\*.* %TD%\TOOLKT11\C\SAMPLES\PM\GRAPHIC1 >NUL
  MD %TD%\TOOLKT11\C\SAMPLES\PM\GRAPHic2 2>NUL
  UNPACK %SD%\C\SAMPLES\GRAPHic2\*.* %TD%\TOOLKT11\C\SAMPLES\PM\GRAPHic2 >NUL
  MD %TD%\TOOLKT11\C\SAMPLES\PM\HELLO1 2>NUL
  UNPACK %SD%\C\SAMPLES\HELLO1\*.* %TD%\TOOLKT11\C\SAMPLES\PM\HELLO1 >NUL
  MD %TD%\TOOLKT11\C\SAMPLES\PM\HELLO2 2>NUL
  UNPACK %SD%\C\SAMPLES\HELLO2\*.* %TD%\TOOLKT11\C\SAMPLES\PM\HELLO2 >NUL
  MD %TD%\TOOLKT11\C\SAMPLES\PM\IMAGE 2>NUL
  UNPACK %SD%\C\SAMPLES\IMAGE\*.* %TD%\TOOLKT11\C\SAMPLES\PM\IMAGE >NUL
  MD %TD%\TOOLKT11\C\SAMPLES\PM\TEMPLATE 2>NUL
  UNPACK %SD%\C\SAMPLES\TEMPLATE\*.* %TD%\TOOLKT11\C\SAMPLES\PM\TEMPLATE >NUL
  MD %TD%\TOOLKT11\C\SAMPLES\PM\TYPEtext 2>NUL
  UNPACK %SD%\C\SAMPLES\TYPEtext\*.* %TD%\TOOLKT11\C\SAMPLES\PM\TYPEtext >NUL

  SELECT %CSLSH%
    WHEN 0    ECHO path c:\os2;%CMainDir%\%CBin%;%TD%\toolkt11\c\samples\pm;%TD%\toolkt11\bin>> %TD%%pmcpath%
              ECHO set lib=%CMainDir%\%CLib%;%TD%\toolkt11\lib>> %TD%%pmcpath%
              ECHO set include=%CMainDir%\%CInc%;%TD%\toolkt11\c\include>> %TD%%pmcpath%
    OTHERWISE ECHO path c:\os2;%CMainDir%%CBin%;%TD%\toolkt11\c\samples\pm;%TD%\toolkt11\bin>> %TD%%pmcpath%
              ECHO set lib=%CMainDir%%CLib%;%TD%\toolkt11\lib>> %TD%%pmcpath%
              ECHO set include=%CMainDir%%CInc%;%TD%\toolkt11\c\include>> %TD%%pmcpath%
  ESELECT
  MD   %CMainDir%\tmp 2>NUL
  ECHO set tmp=%CMainDir%\tmp>> %TD%%pmcpath%
  ECHO %TD%>> %TD%%pmcpath%
  ECHO cd \toolkt11\c\samples\pm>> %TD%%pmcpath%

/*--------------------------------------------------------------------------*
 * Update history file                                                      *
 *--------------------------------------------------------------------------*/
:HISTORY
  HISTORY %TD%\TOOLKT11\BIN\*.*
  HISTORY %TD%\TOOLKT11\LIB\*.*

/*--------------------------------------------------------------------------*
 * Update 'Start Programs' list                                             *
 *--------------------------------------------------------------------------*/
:PM_CHK
  SELECT %PM%
    WHEN 0 GOTO MASM_CHK
  ESELECT

  AIF
  TITLE  Dialog Box Editor
  PATH   %TD%\TOOLKT11\BIN\DLGBOX.EXE
  PROGTYPE WINDOWED
  GROUP  Toolkit Editors
  VISIBLE YES
  EAIF

  AIF
  TITLE  Font Editor
  PATH   %TD%\TOOLKT11\BIN\FONTEDIT.EXE
  PROGTYPE WINDOWED
  GROUP  Toolkit Editors
  VISIBLE YES
  EAIF

  AIF
  TITLE  Icon Editor
  PATH   %TD%\TOOLKT11\BIN\ICONEDIT.EXE
  PROGTYPE WINDOWED
  GROUP  Toolkit Editors
  VISIBLE YES
  EAIF

/*--------------------------------------------------------------------------*/

:MASM_CHK
  SELECT %BSE_MASM%
    WHEN 0 GOTO C_CHK
  ESELECT

  AIF
  TITLE  Hello World MASM Sample
  PATH   %TD%\TOOLKT11\MASM\SAMPLES\BSE\HELLOBAT.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  Family API MASM Sample
  PATH   %TD%\TOOLKT11\MASM\SAMPLES\BSE\FAMAPI.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  DOS Stub MASM Sample
  PATH   %TD%\TOOLKT11\MASM\SAMPLES\BSE\PROMODE.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  Dynamic Link MASM Sample
  PATH   %TD%\TOOLKT11\MASM\SAMPLES\BSE\DYNBLD.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  Memory Allocation MASM Sample
  PATH   %TD%\TOOLKT11\MASM\SAMPLES\BSE\MEMORYB.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  Processes MASM Sample
  PATH   %TD%\TOOLKT11\MASM\SAMPLES\BSE\PROCESSB.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  Threads MASM Sample
  PATH   %TD%\TOOLKT11\MASM\SAMPLES\BSE\THREADB.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  Keyboard and VIO MASM Sample
  PATH   %TD%\TOOLKT11\MASM\SAMPLES\BSE\VIOSAMPB.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  Privilege Level 2 MASM Sample
  PATH   %TD%\TOOLKT11\MASM\SAMPLES\BSE\IOPL2B.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  Critical Error MASM Sample
  PATH   %TD%\TOOLKT11\MASM\SAMPLES\BSE\CRERRB.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  World Trade API MASM Sample
  PATH   %TD%\TOOLKT11\MASM\SAMPLES\BSE\WTBAT.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  Mouse Support MASM Sample
  PATH   %TD%\TOOLKT11\MASM\SAMPLES\BSE\MOUSAMPB.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  Device Driver MASM Sample
  PATH   %TD%\TOOLKT11\MASM\SAMPLES\BSE\DEMODB.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  HISTORY %TD%\TOOLKT11\MASM\SAMPLES\BSE\*.*

/*--------------------------------------------------------------------------*/
:C_CHK
  SELECT %BSE_C%
    WHEN 0 GOTO PMMASM_CHK
  ESELECT
  AIF
  TITLE  Hello World C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\BSE\HELLOCB.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  Family API C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\BSE\FAMAPIC.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  Dynamic Link C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\BSE\DLCBAT.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  Memory Allocation C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\BSE\MEMORYCB.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  Keyboard and VIO C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\BSE\VIOCBAT.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  Critical Error C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\BSE\CRERRCB.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  World Trade API C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\BSE\WTCBAT.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  AIF
  TITLE  Mouse Support C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\BSE\MOUSECB.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  OS/2 Sample Programs
  VISIBLE YES
  EAIF

  HISTORY %TD%\TOOLKT11\C\SAMPLES\BSE\*.*

/*--------------------------------------------------------------------------*/
:PMMASM_CHK
  SELECT %PM_MASM%
    WHEN 0 GOTO PMC_CHK
  ESELECT

  AIF
  TITLE  Hello World MASM Sample
  PATH   %TD%\TOOLKT11\MASM\SAMPLES\PM\HELLOM\HELLOM.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  Presentation Manager Sample Programs
  ICON
  WINDOWDEF
  VISIBLE YES
  EAIF

  HISTORY %TD%\TOOLKT11\MASM\SAMPLES\PM\HELLOM\*.*
  HISTORY %TD%\TOOLKT11\MASM\SAMPLES\PM\*.*

/*--------------------------------------------------------------------------*/
:PMC_CHK
  SELECT %PM_C%
    WHEN 0 GOTO DISPLAY_COMP
  ESELECT

  AIF
  TITLE  Advanced VIO C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\PM\AVIOSAMP\AVIOSAMP.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  Presentation Manager Sample Programs
  ICON
  WINDOWDEF
  VISIBLE YES
  EAIF

  AIF
  TITLE  Bit Map C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\PM\BMAP\BMAP.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  Presentation Manager Sample Programs
  ICON
  WINDOWDEF
  VISIBLE YES
  EAIF

  AIF
  TITLE  Clipboard C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\PM\CLIPBRD\CLIPBRD.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  Presentation Manager Sample Programs
  ICON
  WINDOWDEF
  VISIBLE YES
  EAIF

  AIF
  TITLE  Introductory Dialog Box C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\PM\Dialog1\dialog1.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  Presentation Manager Sample Programs
  ICON
  WINDOWDEF
  VISIBLE YES
  EAIF

  AIF
  TITLE  Further Dialog Box C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\PM\Dialog2\Dialog2.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  Presentation Manager Sample Programs
  ICON
  WINDOWDEF
  VISIBLE YES
  EAIF

  AIF
  TITLE  Font Test C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\PM\FONTTEST\FONTTEST.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  Presentation Manager Sample Programs
  ICON
  WINDOWDEF
  VISIBLE YES
  EAIF

  AIF
  TITLE  Retained Graphics C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\PM\GRAPHIC1\GRAPHIC1.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  Presentation Manager Sample Programs
  ICON
  WINDOWDEF
  VISIBLE YES
  EAIF

  AIF
  TITLE  Non-Retained Graphics C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\PM\GRAPHIC2\GRAPHIC2.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  Presentation Manager Sample Programs
  ICON
  WINDOWDEF
  VISIBLE YES
  EAIF

  AIF
  TITLE  Hello C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\PM\HELLO1\HELLO1.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  Presentation Manager Sample Programs
  ICON
  WINDOWDEF
  VISIBLE YES
  EAIF

  AIF
  TITLE  Standard Window C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\PM\HELLO2\HELLO2.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  Presentation Manager Sample Programs
  ICON
  WINDOWDEF
  VISIBLE YES
  EAIF

  AIF
  TITLE  Image C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\PM\IMAGE\IMAGE.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  Presentation Manager Sample Programs
  ICON
  WINDOWDEF
  VISIBLE YES
  EAIF

  AIF
  TITLE  Template C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\PM\TEMPLATE\TEMPLATE.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  Presentation Manager Sample Programs
  ICON
  WINDOWDEF
  VISIBLE YES
  EAIF

  AIF
  TITLE  Typing C Sample
  PATH   %TD%\TOOLKT11\C\SAMPLES\PM\TYPETEXT\TYPETEXT.CMD
  PARAMETERS %TD%
  PROGTYPE FULLSCREEN
  GROUP  Presentation Manager Sample Programs
  ICON
  WINDOWDEF
  VISIBLE YES
  EAIF

  HISTORY %TD%\TOOLKT11\C\SAMPLES\PM\AVIOSAMP\*.*
  HISTORY %TD%\TOOLKT11\C\SAMPLES\PM\BMAP\*.*
  HISTORY %TD%\TOOLKT11\C\SAMPLES\PM\CLIPBRD\*.*
  HISTORY %TD%\TOOLKT11\C\SAMPLES\PM\DIALOG1\*.*
  HISTORY %TD%\TOOLKT11\C\SAMPLES\PM\DIALOG2\*.*
  HISTORY %TD%\TOOLKT11\C\SAMPLES\PM\FONTTEST\*.*
  HISTORY %TD%\TOOLKT11\C\SAMPLES\PM\GRAPHIC1\*.*
  HISTORY %TD%\TOOLKT11\C\SAMPLES\PM\GRAPHIC2\*.*
  HISTORY %TD%\TOOLKT11\C\SAMPLES\PM\HELLO1\*.*
  HISTORY %TD%\TOOLKT11\C\SAMPLES\PM\HELLO2\*.*
  HISTORY %TD%\TOOLKT11\C\SAMPLES\PM\IMAGE\*.*
  HISTORY %TD%\TOOLKT11\C\SAMPLES\PM\TEMPLATE\*.*
  HISTORY %TD%\TOOLKT11\C\SAMPLES\PM\TYPETEXT\*.*
  HISTORY %TD%\TOOLKT11\C\SAMPLES\PM\*.*
  HISTORY %TD%\TOOLKT11\C\SAMPLES\PM\*.*

/*--------------------------------------------------------------------------*
 * Successful completion                                                    *
 *--------------------------------------------------------------------------*/
:DISPLAY_COMP
  DISPLAY TKCOMP ENTER HELP
  DISPLAY TKWAIT
  LIBRARY /D %SD%TOOLKIT.LIB
  DEL C:\OS2\TOOLKIT.LIB
  EXIT 0

/*--------------------------------------------------------------------------*
 * Failure                                                                  *
 *--------------------------------------------------------------------------*/
:EXIT_ONE
  DISPLAY TKABEND ESC ENTER HELP
  SELECT %CHOICE%
    WHEN 2 GOTO ABEND
  ESELECT
  RETURN

:ABEND
  LIBRARY /D %SD%TOOLKIT.LIB
  DEL C:\OS2\TOOLKIT.LIB
  EXIT 1
