#define INCL_WIN
#define INLC_DOS

#include <os2.h>

#include <stdio.h>

#include "tb.ext"
#include "tb.ids"
#include "tb.h"
#include "tbx.h"

MRESULT EXPENTRY NewFrameProc(HWND, USHORT, MPARAM, MPARAM);
HWND hwndMenuBar,hwndToolBar,hnwdClient;

VOID UfMainCreate(PGPFPARMS pGpf)
{
PFNWP pfnwpOldProc;
HMODULE hmod;

	pfnwpOldProc= WinSubclassWindow(hwndFrameMain,(PFNWP) NewFrameProc);
	WinSetWindowULong(hwndFrameMain, QWL_USER, (ULONG) pfnwpOldProc);
	hwndMenuBar= WinLoadMenu(hwndFrameMain,(HMODULE)NULL,ID_MAIN);
	hwndToolBar= WinLoadMenu(hwndFrameMain,(HMODULE)NULL,ID_TOOLBAR);
}

VOID UfMainCommand(PGPFPARMS pGpf)
{
PSZ psz= (PSZ)NULL;

	 switch(pGpf->Command){
	 case MID_TB_1:
        psz= "Pressed: I";
		WinSendMsg(
            pGpf->hwnd,WM_COMMAND,
            MPFROMSHORT(ID_PULLDOWNEXTENDEDHELP),
            MPFROM2SHORT(CMDSRC_MENU,TRUE));
		break;
	 case MID_TB_2:
		psz= "Pressed: II";
		break;
	 case MID_TB_3:
		psz= "Pressed: III";
		break;
	 case MID_TB_4:
		psz= "Pressed: IV";
		break;
	 case MID_TB_5:
		psz= "Pressed: V";
		break;
	 case MID_TB_6:
		psz= "Pressed: VI";
		break;
	 case MID_TB_7:
		psz= "Pressed: VII";
		break;
	 case MID_TB_8:
		psz= "Pressed: VIII";
		break;
	 case MID_TB_9:
		psz= "Pressed: IX";
		break;
	 case MID_TB_10:
		psz= "Pressed: X";
		break;
	 default:
		pGpf->mresult=
			GpfDefWindowProc(pGpf->hwnd,pGpf->msg,pGpf->mp1,pGpf->mp2);
	 }

    if(psz != NULL)
       WinSetWindowText(hwndFrameMain,psz);

	 return;

}

MRESULT EXPENTRY NewFrameProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
PFNWP pfnwpOldProc;

	 pfnwpOldProc= (PFNWP) WinQueryWindowULong(hwnd, QWL_USER);

	 switch(msg){
		 case WM_QUERYFRAMECTLCOUNT:
			{
			 USHORT usItemCount;
			 usItemCount= SHORT1FROMMR(pfnwpOldProc(hwnd,msg,mp1,mp2));
			 return (MRESULT) ++usItemCount;
			 }
		 case WM_FORMATFRAME:
			 {PSWP pSWP;
			 USHORT usNewMenu;
			 USHORT usItemCount;
			 USHORT usToolBarIndex=0;
			 USHORT usClientIndex=0;
			 USHORT usVScrollIndex=0;
			 HWND hwndVertScroll;

			 pSWP= PVOIDFROMMP(mp1);
			 usItemCount= SHORT1FROMMR(pfnwpOldProc(hwnd,msg,mp1,mp2));
			 for( ;usToolBarIndex<usItemCount;usToolBarIndex++)
				if(pSWP[usToolBarIndex].hwnd == hwndToolBar)
				   break;
			 for( ;usClientIndex<usItemCount;usClientIndex++)
				if(pSWP[usClientIndex].hwnd == hwndMain)
				   break;
			 if((hwndVertScroll =
				WinWindowFromID(hwnd,FID_VERTSCROLL)) != NULLHANDLE)
				   for( ;usVScrollIndex<usItemCount; usVScrollIndex++)
					  if(pSWP[usVScrollIndex].hwnd == hwndVertScroll)
						 break;
			 usNewMenu= usItemCount;
			 pSWP[usNewMenu].fl= SWP_SIZE;
			 pSWP[usNewMenu].cx= pSWP[usToolBarIndex].cx;
			 pSWP[usNewMenu].cy= pSWP[usToolBarIndex].cy;
			 pSWP[usNewMenu].hwndInsertBehind= HWND_TOP;
			 pSWP[usNewMenu].hwnd= hwndMenuBar;
			 WinSendMsg(hwndMenuBar,
				 WM_ADJUSTWINDOWPOS,
				 MPFROMP(pSWP+usNewMenu),(MPARAM)0L);
			 pSWP[usNewMenu].x= pSWP[usToolBarIndex].x;
			 pSWP[usNewMenu].y= pSWP[usToolBarIndex].y -
				 pSWP[usNewMenu].cy;
			 pSWP[usNewMenu].fl= pSWP[usToolBarIndex].fl;
			 pSWP[usClientIndex].cy -= pSWP[usNewMenu].cy;
			 if(hwndVertScroll != NULLHANDLE)
				pSWP[usVScrollIndex].cy -= pSWP[usNewMenu].cy;
			 return (MRESULT) ++usItemCount;
			 }
		  default:
			 return (pfnwpOldProc(hwnd,msg,mp1,mp2));
			 break;
	 }

	 return FALSE;
}

VOID UfPBDel(PGPFPARMS pGpf)
{
    WinSendMsg(
        hwndToolBar,
        MM_DELETEITEM,
        MPFROM2SHORT(MID_TB_9,FALSE),
        (MPARAM)0L);
}

VOID UfPBAdd(PGPFPARMS pGpf)
{
HBITMAP hbm;
MENUITEM mi;
HPS hps;

    hps= WinGetPS(hwndToolBar);
    hbm= GpiLoadBitmap(hps,NULLHANDLE,MID_EXTRA,32L,32L);
    mi.iPosition= 9;
    mi.afStyle= MIS_BITMAP;
    mi.afAttribute= 0;
    mi.id= MID_EXTRA;
    mi.hItem= (ULONG)hbm;

    WinSendMsg(
        hwndToolBar,
        MM_INSERTITEM,
        MPFROMP(&mi),
       (MPARAM)0L);

    WinReleasePS(hps);
}


