/*========================================================================= 
 *                                 CS 488/688                                
 *                          Introduction to Graphics                        
 *                                                                         
 *                           Assignment 1: OpenGL                         
 *                                                                       
 *=========================================================================*/
#ifndef _GR_
#define _GR_

/* Also includes Tcl/Tk, GL/gl.h, X11/Xlib stuff */
#define X11
#include "togl.h"

/* Gr Types */
typedef struct {
   double    r,g,b;    /* RGB */
} GrColour;

typedef struct {
   double    x,y;      /* XY */
} GrPoint2D;

typedef struct { 
   double    x,y,z;    /* XYZ */
} GrPoint3D;

typedef struct { 
   double    x,y,z;    /* XYZ-vector */
} GrVector3D;

typedef double GrMatrix4x4[4][4];     /* [row][column] */

typedef enum {
	GR_FALSE = 0,
	GR_NO = 0,
	GR_OFF = 0,
	GR_TRUE = 1,
	GR_YES = 1,
	GR_ON = 1
} GrBoolean;

typedef struct _GrPolygon {
	int nr_vertices;
	GrPoint3D *vertices;
} GrPolygon;

typedef enum { 
	GR_NONE, 
	GR_LINEAR, 
	GR_QUADRATIC
} GrAttenuation;

/* Gr commands 
 *
 * A pointer to a (statically allocated) error message should be
 * returned explaining any errors; a NULL return indicates success.
 *
 * These functions don't have access to OpenGL or Togl functions, 
 * since they are not guaranteed to be called in an OpenGL context.   
 * They should just change some state stored in the Gr module
 * for later interpretation during the display callback.
 */
extern char* gr_mode(char mode);
extern char* gr_buffer(char mode);
extern char* gr_lighting(char* lighting);
extern char* gr_save(char* filename);
extern char* gr_rotate(char axis, double angle);
extern char* gr_scale(double factor);
extern char* gr_reset();

/* ToGL callbacks 
 */
extern void gr_initialize(struct Togl* togl);
extern void gr_reshape(struct Togl* togl);
extern void gr_render(struct Togl* togl);

#endif /* _GR_ */


