/*========================================================================= 
 *                                 CS 488/688                                
 *                          Introduction to Graphics                        
 *                                                                         
 *                           Assignment 1: OpenGL                         
 *                                                                       
 *=========================================================================*/
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <math.h>

#ifdef __EMX__
#include <float.h>
#else
#include <values.h>
#endif /* __EMX__ */

#include "util.h"
#include "gr.h"
#include "Draw.h"

/*========================================================================= 
 * Tcl/Gr commands:
 *    These commands change the internal state of Gr, but do not
 *    directly request any rendering (they can't, since they have no
 *    access to the Togl handle, and may be called before an OpenGL
 *    context is even available).
 *
 *    A pointer to a statically allocated string should be returned in
 *    case of an error, (char *)0 in case of success.
 *=========================================================================*/

/*-------------------------------------------------------------------------
 * gr_mode:
 *-------------------------------------------------------------------------*/
char*
gr_mode (
	char mode
) {
	fprintf(stderr,"Called: gr_mode(mode=\"%c\")\n",mode);
  	return "Not implemented";
}

/*-------------------------------------------------------------------------
 * gr_buffer:
 *   Turn double buffering on or off
 *-------------------------------------------------------------------------*/
char*
gr_buffer (
	char mode
) {
	fprintf(stderr,"Called: gr_buffer(mode=\"%c\")\n",mode);
  	return "Not implemented";
}

/*-------------------------------------------------------------------------
 * gr_lighting:
 *   Set the lighting mode
 *-------------------------------------------------------------------------*/
char*
gr_lighting (
	char* lighting
) {
	fprintf(stderr,"Called: gr_lighting(lighting=\"%s\")\n",lighting);
  	return "Not implemented";
}

/*-------------------------------------------------------------------------
 * gr_save:
 *   Save the current image to a file
 *-------------------------------------------------------------------------*/
char*
gr_save (
	char* filename
) {
	fprintf(stderr,"Called: gr_save(filename=\"%s\")\n",filename);
  	return "Not implemented";
}

/*-------------------------------------------------------------------------
 * gr_reset:
 *   Return Gr state to its initial configuration.
 *-------------------------------------------------------------------------*/
char*
gr_reset (
	void
) {
	fprintf(stderr,"Called: gr_reset()\n");
  	return (char *)0;
}

/*-------------------------------------------------------------------------
 * gr_rotate:
 *   Rotate object about x,y, or z axis by a particular angle in degrees.
 *-------------------------------------------------------------------------*/
char*
gr_rotate (
	char axis, 
	double angle
) {
	fprintf(stderr,"Called: gr_rotate(axis='%c',angle=%f)\n",axis,angle);
  	return "Not implemented";
}

/*-------------------------------------------------------------------------
 * gr_scale:
 *   Scale object by a given factor.
 *-------------------------------------------------------------------------*/
char*
gr_scale (
	double factor
) {
	fprintf(stderr,"Called: gr_scale(factor=%f)\n",factor);
  	return "Not implemented";
}

/*========================================================================= 
 * Togl callbacks:
 *    These functions are called by Togl when certain events (such as
 *    <Expose>) occur, or when requested using a togl subcommand (such as
 *    render).
 *=========================================================================*/

/*-------------------------------------------------------------------------
 * gr_reshape:
 *    When the display area changes size, recompute the perspective matrix
 *    and reload, maintaining the aspect ratio.
 *-------------------------------------------------------------------------*/
void
gr_reshape(
	struct Togl* togl
) {
	int width, height;

	/* Get new size of display 
     */
	width = Togl_Width(togl);
	height = Togl_Height(togl);

	/* Set up perspective projection, using current size and aspect
	 * ratio of display
	 */
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glViewport(0, 0, width, height);
	gluPerspective(40.0, (GLfloat)width/(GLfloat)height, 0.1, 1000.0);

	/* Reset to modelview matrix mode
     */
	glMatrixMode(GL_MODELVIEW);
}

/*-------------------------------------------------------------------------
 * gr_render:
 *    Actually draw the scene using OpenGL, using the state previously set
 *-------------------------------------------------------------------------*/
void
gr_render(
	struct Togl* togl
) {
	/* Reset modelview matrix
     */
	glLoadIdentity();

	/* Clear framebuffer (both colour and depth buffers)
     */
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

#ifdef __EMX__
	/* Helps illustarate the Double Buffer vs Single Buffer in OS/2. */
	glFlush();
#endif

	/* Translate local coordinate system away from camera 
     */
	glTranslatef(0, 0, -6);

	/* Draw cube in new local coordinate system
     */
	DrawUnitCube();

	/* Force OpenGL drawing to completion and swap buffers
     */
	Togl_SwapBuffers(togl);
}

/*-------------------------------------------------------------------------
 * gr_initialize:
 *    Once togl widget created, intialize OpenGL context and gr state to
 *    values we want
 *-------------------------------------------------------------------------*/
void 
gr_initialize (
	struct Togl* togl
) {
	/* Turn on Gouraud shading
     */
	glShadeModel(GL_SMOOTH);

	/* Create a bluish background when clear colour buffers
     */
	glClearColor(0.3,0.3,0.8,0.0);

	/* Enable depth test
     */
	glEnable(GL_DEPTH_TEST);

	/* Initialize the cube display list
     */
	MakeUnitCube();
}

