/*========================================================================= 
 *                                 CS 488/688                                
 *                          Introduction to Graphics                        
 *                                                                         
 *                           Assignment 1: OpenGL                         
 *                                                                       
 *=========================================================================*/
#include <stdio.h>
#include <stdlib.h>
#include <GL/gl.h> 

#include "gr.h"
#include "util.h"
#include "Draw.h"

/* Colour Definitions */
GrColour black    = {0.0, 0.0, 0.0};
GrColour red      = {1.0, 0.0, 0.0};
GrColour green    = {0.0, 1.0, 0.0};
GrColour yellow   = {1.0, 1.0, 0.0};
GrColour blue     = {0.0, 0.0, 1.0};
GrColour magenta  = {1.0, 0.0, 1.0};
GrColour cyan     = {0.0, 1.0, 1.0};
GrColour white    = {1.0, 1.0, 1.0};
GrColour grey     = {0.5, 0.5, 0.5};

GrPolygon unitCube[6];
  
/*
 * MakeUnitCube
 */
void MakeUnitCube(void)
{
  int i;

  for (i=0; i<6; i++) {
    unitCube[i].nr_vertices = 4;
    unitCube[i].vertices = (GrPoint3D *) malloc (4 * sizeof(GrPoint3D));
  }

  /* Bottom Plane (4, 3, 2, 1) */
  unitCube[0].vertices[0] = mkPoint3D(1.0, -1.0, -1.0);
  unitCube[0].vertices[1] = mkPoint3D(1.0, -1.0, 1.0);
  unitCube[0].vertices[2] = mkPoint3D(-1.0, -1.0, 1.0);
  unitCube[0].vertices[3] = mkPoint3D(-1.0, -1.0, -1.0);

  /* Top Plane (6, 7, 8, 5) */
  unitCube[1].vertices[0] = mkPoint3D(-1.0, 1.0, -1.0);
  unitCube[1].vertices[1] = mkPoint3D(-1.0, 1.0, 1.0);
  unitCube[1].vertices[2] = mkPoint3D(1.0, 1.0, 1.0);
  unitCube[1].vertices[3] = mkPoint3D(1.0, 1.0, -1.0);

  /* Front Plane (2, 3, 8, 7) */
  unitCube[2].vertices[0] = mkPoint3D(-1.0, -1.0, 1.0);
  unitCube[2].vertices[1] = mkPoint3D(1.0, -1.0, 1.0);
  unitCube[2].vertices[2] = mkPoint3D(1.0, 1.0, 1.0);
  unitCube[2].vertices[3] = mkPoint3D(-1.0, 1.0, 1.0);

  /* Back Plane (6, 5, 4, 1) */
  unitCube[3].vertices[0] = mkPoint3D(-1.0, 1.0, -1.0);
  unitCube[3].vertices[1] = mkPoint3D(1.0, 1.0, -1.0);
  unitCube[3].vertices[2] = mkPoint3D(1.0, -1.0, -1.0);
  unitCube[3].vertices[3] = mkPoint3D(-1.0, -1.0, -1.0);

  /* Left Plane (1, 2, 7, 6) */
  unitCube[4].vertices[0] = mkPoint3D(-1.0, -1.0, -1.0);
  unitCube[4].vertices[1] = mkPoint3D(-1.0, -1.0, 1.0);
  unitCube[4].vertices[2] = mkPoint3D(-1.0, 1.0, 1.0);
  unitCube[4].vertices[3] = mkPoint3D(-1.0, 1.0, -1.0);

  /* Right Plane (5, 8, 3, 4) */
  unitCube[5].vertices[0] = mkPoint3D(1.0, 1.0, -1.0);
  unitCube[5].vertices[1] = mkPoint3D(1.0, 1.0, 1.0);
  unitCube[5].vertices[2] = mkPoint3D(1.0, -1.0, 1.0);
  unitCube[5].vertices[3] = mkPoint3D(1.0, -1.0, -1.0);
}


/*
 * DrawPolygon
 */
void DrawPolygon(GrPolygon poly, GrVector3D normal)
{
  glBegin(GL_POLYGON);
  {
    glNormal3d(normal.x, normal.y, normal.z);
    glVertex3d(poly.vertices[0].x, poly.vertices[0].y, poly.vertices[0].z);
    glNormal3d(normal.x, normal.y, normal.z);
    glVertex3d(poly.vertices[1].x, poly.vertices[1].y, poly.vertices[1].z);
    glNormal3d(normal.x, normal.y, normal.z);
    glVertex3d(poly.vertices[2].x, poly.vertices[2].y, poly.vertices[2].z);
    glNormal3d(normal.x, normal.y, normal.z);
    glVertex3d(poly.vertices[3].x, poly.vertices[3].y, poly.vertices[3].z);
  }
  glEnd();
}


/*
 * DrawUnitCube
 */
void DrawUnitCube(void)
{
  int i;
  GrVector3D normal;

    /* Hide the back surface. */
    glCullFace(GL_BACK); 
    glEnable(GL_CULL_FACE);

    /* Draw a red cube */
    glColor3f(1, 0, 0);

    /* Bottom Plane */
    normal = mkVector3D(0.0, -1.0, 0.0);
    DrawPolygon(unitCube[0], normal); 
 
    /* Top Plane */
    normal = mkVector3D(0.0, 1.0, 0.0);
    DrawPolygon(unitCube[1], normal);

    /* Front Plane */
    normal = mkVector3D(0.0, 0.0, 1.0);
    DrawPolygon(unitCube[2], normal); 

    /* Back Plane */
    normal = mkVector3D(0.0, 0.0, -1.0);
    DrawPolygon(unitCube[3], normal);  

    /* Left Plane */
    normal = mkVector3D(-1.0, 0.0, 0.0);
    DrawPolygon(unitCube[4], normal); 

    /* Right Plane */
    normal = mkVector3D(1.0, 0.0, 0.0);
    DrawPolygon(unitCube[5], normal);  
}


