/****************************************************************************
    $Id: watcom.h 501.0 1995/03/07 12:26:48 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:    Tarma Library for C++ V5.0
    Author:     Ron van der Wal

    Watcom-specific declarations of compilation and keyword-like names.

    $Log: watcom.h $
    Revision 501.0  1995/03/07 12:26:48  RON
    Updated for TLX 5.01
    Revision 1.7  1995/01/31 16:32:20  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.6  1994/11/16  15:24:12  ron
    Added _CCNAME, _CCVER, and _MODEL definitions

    Revision 1.5  1994/10/13  11:56:04  ron
    Small formatting changes

    Revision 1.4  1994/10/06  17:50:13  ron
    Added _NOMUTABLE

    Revision 1.3  1994/10/05  18:27:19  ron
    Added #defines for Watcom 32-bit platforms

    Revision 1.2  1994/09/08  15:55:37  ron
    Moved O/S-specific macros into this file

    Revision 1.1  1994/08/16  18:06:57  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_WATCOM_H
#define _TLX_WATCOM_H

#ifndef __WATCOMC__
#error This file is for Watcom compilations only
#endif

#define _CCNAME		Watcom C++
#define _CCVER		__WATCOMC__

#ifdef _DLL
    #define _IN_DLL     1
#endif

#define _NORTTI		1
#define _NOBOOL		1
#define _NOMUTABLE	1

#ifdef __FLAT__                 /* Non-segmented platforms */

    #define _Near
    #define _Far
    #define _Huge
    #define _MODEL		Flat

    #define _ExportClass        __export
    #define _ExportFunc         __export
    #define _ExportData         __export

    #define _ImportClass
    #define _ImportFunc
    #define _ImportData

  #if defined(__OS2__)
    #define OS_OS2	1
  #elif defined(__NT__)
    #define OS_WIN32	1
    #define OS_WINXXX	1
  #else
    #error Unknown FLAT Watcom C++ platform
  #endif

    #define _CPU_I86    1
    #define _LENDIAN    1
    #define _NULL_IS_0  1
    #define _MEM_FLAT   1

#else                           /* Segmented memory architectures */

    #define _Near               __near
    #define _Far                __far
    #define _Huge               __huge

    #define _ExportClass        __export
    #define _ExportFunc         __export __far
    #define _ExportData         __export __far

    #define _ImportClass        __huge
    #define _ImportFunc         __far
    #define _ImportData         __far

    #if defined(M_I86TM) || defined(M_I86SM)
        #define _CODE_NEAR      1
        #define _DATA_NEAR      1
    	#define _MODEL		Tiny/Small
    #elif defined(M_I86CM)
        #define _CODE_NEAR      1
        #define _DATA_FAR       1
    	#define _MODEL		Compact
    #elif defined(M_I86MM)
        #define _DATA_NEAR      1
        #define _CODE_FAR       1
    	#define _MODEL		Medium
    #elif defined(M_I86LM) || defined(M_I86HM)
        #define _CODE_FAR       1
        #define _DATA_FAR       1
    	#define _MODEL		Large/Huge
    #else
        #error Unknown Watcom memory model
    #endif

    #define _CPU_I86    1
    #define _LENDIAN    1
    #define _NULL_IS_0  1
    #define _MEM_SEG    1

    #if defined(__WINDOWS__)
    	#define OS_WIN16    1
    	#define OS_WINXXX   1
    #else
    	#define OS_DOS      1
    	#define OS_DOSXXX   1
    #endif
#endif

#endif  /* _TLX_WATCOM_H */
