/****************************************************************************
    $Id: util.h 501.0 1995/03/07 12:26:48 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Declarations of global utility functions.

    $Log: util.h $
    Revision 501.0  1995/03/07 12:26:48  RON
    Updated for TLX 5.01
    Revision 1.9  1995/01/31 16:29:28  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.8  1995/01/17  16:59:26  ron
    Added tlRange() function template

    Revision 1.7  1994/10/05  18:27:07  ron
    Renamed TLx...() functions to tl...()

    Revision 1.6  1994/09/28  14:29:47  ron
    Removed Macintosh-style #include references

    Revision 1.5  1994/09/27  20:25:55  ron
    Changed path separator from / to \

    Revision 1.4  1994/09/26  15:25:11  ron
    Renamed MAKESTR() macro to STR()

    Revision 1.3  1994/09/07  15:34:30  ron
    Removed TlxXxxx() information functions to tlx.h
    Small formatting changes

    Revision 1.2  1994/09/06  13:59:36  ron
    Adapted to new (beta) release of Symantec C++ compiler

    Revision 1.1  1994/08/16  18:06:56  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_UTIL_H
#define _TLX_UTIL_H

#ifndef _TLX_TLX_H
#include <tlx\501\tlx.h>
#endif

/*---------------------------------------------------------------------------
    Various macros
---------------------------------------------------------------------------*/

// The VERSION macro creates a string with version information; its arguments
// are typically a version number (e.g. 2.3) followed by a revision number.
// The version string conforms to the Novell format, and will be recognized
// by utilities such as VERSION from Novell and NOVER from Tarma Software
// Research.

#define VERSION(ver,rel) \
    "VeRsIoN=" #ver "r" #rel " (" __DATE__ " " __TIME__ ")"

// STR() expands its argument to a quoted string. The _STR() helper macro
// is necessary to help expand STR() arguments that are themselves
// macros; ANSI-C (and C++) require an extra level of indirection for them.

#define	_STR(s)		#s
#define STR(a)		_STR(a)

// TABLE_SIZE() returns the number of elements in a C-style vector table

#define	TABLE_SIZE(tbl)	(sizeof(tbl) / sizeof(tbl[0]))

/*---------------------------------------------------------------------------
    Utility functions
---------------------------------------------------------------------------*/

int16 		_TLXFUNC tlSwap16(int16);	// Swap bytes in 16-bit int
int32 		_TLXFUNC tlSwap32(int32);	// Swap bytes in 32-bit int

index_t		_TLXFUNC tlStrHash(const char *);
index_t		_TLXFUNC tlPtrHash(const void *);

char * 		_TLXFUNC tlStrDup(const char *, size_t = 0);

// Overload 'tlSwapBytes()' for all relevant integer sizes.

inline int16	tlSwapBytes(int16 aInt)  { return tlSwap16(aInt); }
inline int32	tlSwapBytes(int32 aInt)  { return tlSwap32(aInt); }
inline uint16	tlSwapBytes(uint16 aInt) { return tlSwap16(aInt); }
inline uint32	tlSwapBytes(uint32 aInt) { return tlSwap32(aInt); }

template<class T> void tlSwap(T &a, T &b)
{
    T tmp = a;
    a = b;
    b = tmp;
}

template<class T> T tlMax(T a, T b) { return a >= b ? a : b; }
template<class T> T tlMin(T a, T b) { return a <= b ? a : b; }
template<class T> T tlRange(T lo, T val, T hi)
    { return val <= lo ? lo : val >= hi ? hi : val; }

// Inline versions for data types that generate little code, or an amount
// of code comparable to the code required to call a non-inline function.

#define _INL_MAX(T)	inline T tlMax(T a, T b) { return a >= b ? a : b; }
#define _INL_MIN(T)	inline T tlMin(T a, T b) { return a <= b ? a : b; }

_INL_MAX(short)
_INL_MAX(int)
_INL_MAX(long)
_INL_MAX(unsigned short)
_INL_MAX(unsigned int)
_INL_MAX(unsigned long)
_INL_MAX(float)
_INL_MAX(double)
#ifndef __SC__		// Symantec C++ has no 'long double'
_INL_MAX(long double)
#endif

_INL_MIN(short)
_INL_MIN(int)
_INL_MIN(long)
_INL_MIN(unsigned short)
_INL_MIN(unsigned int)
_INL_MIN(unsigned long)
_INL_MIN(float)
_INL_MIN(double)
#ifndef __SC__		// Symantec C++ has no 'long double'
_INL_MIN(long double)
#endif

#undef _INL_MAX
#undef _INL_MIN

#endif	// _TLX_UTIL_H
