/****************************************************************************
    $Id: tlx.h 501.0 1995/03/07 12:28:50 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:    Tarma Library for C++
    Author:     Ron van der Wal

    Typedefs, manifest constants, and more that are generally platform
    dependent.

    $Log: tlx.h $
    Revision 501.0  1995/03/07 12:28:50  RON
    Updated for TLX 5.01
    Revision 1.17  1995/02/28 15:08:30  RON
    Update for release 012
    Added partial support for SunPro C++ compiler

    Revision 1.16  1995/01/18  18:56:27  ron
    No changes

    Revision 1.15  1995/01/12  13:31:31  ron
    Updated revision number

    Revision 1.14  1995/01/06  16:01:51  ron
    Changed revision number to 008

    Revision 1.13  1995/01/05  15:34:46  ron
    Simplified compilation flags

    Revision 1.12  1994/11/16  15:23:41  ron
    Many small changes

    Revision 1.11  1994/10/10  17:05:50  ron
    Added TLX::Maturity() indicator

    Revision 1.10  1994/10/07  17:08:50  ron
    Changed word and dword mapping macros

    Revision 1.9  1994/10/05  18:25:36  ron
    Renamed TLx...() functions to tl...()
    Removed comments regarding link time checks
    Changed some macros because of SC++ 7.0 bugs

    Revision 1.8  1994/09/28  14:29:24  ron
    Updated release number to 004

    Revision 1.7  1994/09/27  20:25:51  ron
    Changed path separator from / to \

    Revision 1.6  1994/09/26  15:24:31  ron
    Changed version number construction
    Changed compilation/link checks

    Revision 1.5  1994/09/12  14:52:05  ron
    Small formatting changes

    Revision 1.4  1994/09/08  15:54:49  ron
    Removed O/S-specific macros to individual compiler files
    Added link time checks for DLL vs. static version

    Revision 1.3  1994/09/07  15:33:41  ron
    Added special TLX class to catch compilation/linking mismatches
    Moved several TlxXxx() information functions to class TLX

    Revision 1.2  1994/09/06  13:56:16  ron
    Added support for 16- and 32-bit DOS extenders
    Added support for new C++ type 'bool'
    Changed style of constants to 'kConstantName'

    Revision 1.1  1994/08/16  18:06:54  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_TLX_H
#define _TLX_TLX_H

#ifndef __cplusplus
#error TLX is a C++ library; C compilations are not supported.
#endif

//-----	Macro utilities

#define __CC2(a,b)		a ## b
#define _CC2(a,b)		__CC2(a,b)
#define __CC3(a,b,c)		a ## b ## c
#define _CC3(a,b,c)		__CC3(a,b,c)
#define __CC4(a,b,c,d)		a ## b ## c ## d
#define _CC4(a,b,c,d)		__CC4(a,b,c,d)
#define __CC5(a,b,c,d,e)	a ## b ## c ## d ## e
#define _CC5(a,b,c,d,e)		__CC5(a,b,c,d,e)

//-----	Version information

#define _TLXMAJ		5		// Major version number
#define _TLXMIN         01		// Minor version number
#define _TLXREV         000		// Revision number

#define _TLXVER         _CC3(0x,_TLXMAJ,_TLXMIN)	// Hexadecimal
#define _TLXDEC         _CC2(_TLXMAJ,_TLXMIN)		// Decimal
#define _TLXVNAME	_CC5(V,_TLXMAJ,_TLXMIN,r,_TLXREV) // Vddd.rrr

#ifdef _TLXDLL
  #define _TLXDS	DLL
#else
  #define _TLXDS	Static
#endif

#ifdef _TLXDBG
  #define _TLXDR	Debug
#else
  #define _TLXDR	Retail
#endif

//-----	Instructions to LINT

//lint -esym(553,OS_BSD,OS_DOS,OS_DOS286,OS_DOS386,OS_DOSXXX,OS_MAC,OS_OS2)
//lint -esym(553,OS_WIN16,OS_WIN32,OS_WIN32S,OS_WINXXX)
//lint -e1725			Don't complain about reference data members

/*---------------------------------------------------------------------------
    Find out on what target platform we are supposed to run:

    OS_BSD      - defined on BSD Unix platforms
    OS_DOS      - defined on 16-bit real mode DOS platforms
    OS_DOS286   - defined on 16-bit protected mode DOS platforms
    OS_DOS386   - defined on 32-bit protected mode DOS platforms
    OS_DOSXXX	- defined on all DOS platforms
    OS_MAC      - defined on Macintosh 6.x and above platforms
    OS_OS2      - defined on OS/2 2.x platforms
    OS_SCO      - defined on SCO Unix platforms
    OS_SV4      - defined on Unix SVR4.2 platforms
    OS_UNIX     - defined on all Unix platforms
    OS_WIN16    - defined on 16-bit Windows platforms
    OS_WIN32    - defined on 32-bit Windows platforms
    OS_WIN32S   - defined on 32-bit subset Windows platforms
    OS_WINXXX	- defined on all Windows platforms

    The one-to-one relation between platform and processor is blurring
    (it wasn't that clear for Unix systems anyway), so we take this into
    account as well:

    _CPU_ALPHA  - Alpha
    _CPU_I86    - Intel 80x86, i486, Pentium, or compatible
    _CPU_M68    - Motorola 680xx or compatible
    _CPU_MIPS   - MIPS
    _CPU_PPC    - Motorola/IBM PowerPC
    _CPU_SPARC  - Sparc

    This determination takes place based on compiler-specific headers.
    These headers also contain compiler-specific versions of keywords.
---------------------------------------------------------------------------*/

#if defined(__TURBOC__)
    #include <tlx\501\borland.h>
#elif defined(_MSC_VER)
    #include <tlx\501\microsof.h>
#elif defined(__IBMC__) || defined(__IBMCPP__)
    #include <tlx\501\ibm.h>
#elif defined (THINK_CPLUS)
    #include <tlx\501\think.h>
#elif defined (__SC__)
    #include <tlx\501\symantec.h>
#elif defined(__WATCOMC__)
    #include <tlx\501\watcom.h>
#elif defined(__ZTC__>
    #include <tlx\501\zortech.h>
#elif defined(__SUNPRO_CC>
    #include <tlx\501\sunpro.h>
#else
    #error Unsupported compiler type; contact Tarma Software Research
    #include <tlx\501\compiler.h>
#endif

// Check required macros

#if !OS_DOSXXX && !OS_MAC && !OS_OS2 && !OS_WINXXX && !OS_UNIX
#error Must specify a target platform
#endif

#if !_MEM_FLAT && !_MEM_SEG
#error Must specify a memory architecture
#elif _MEM_FLAT && _MEM_SEG
#error Must specify exactly 1 memory architecture
#endif

#if !_CPU_I86 && !_CPU_M68 && !_CPU_SPARC
#error Must specify a processor architecture
#elif _CPU_I86 && _CPU_M68
#error Must specify exactly 1 processor architecture
#endif

#if !_BENDIAN && !_LENDIAN
#error Must specify an endianity
#elif _BENDIAN && _LENDIAN
#error Must specify exactly 1 endianity
#endif

// Provide defaults for non-required macros

#ifndef _CCNAME
#define _CCNAME		Unknown compiler
#endif
#ifndef _CCVER
#define _CCVER		0
#endif
#ifndef _MODEL
#define _MODEL          Unknown
#endif
#ifndef _RTLCLASS
#define _RTLCLASS       // Empty
#endif

/*---------------------------------------------------------------------------
    ANSI/ISO C++ extensions that are not always available yet. Some specific
    extensions are covered in other files:

    except.h	- exceptions and 'throw'
    rtti.h	- RTTI and new-style casts
---------------------------------------------------------------------------*/

#include <limits.h>     	// Pull in the ANSI-C limits for convenience
#include <stddef.h>     	// ANSI-C declarations of size_t and others

class _RTLCLASS ostream;        // To avoid #including <iostream.h>

#ifndef _NORTTI
#include <typeinfo.h>		// Required by some compilers, useful on most
#endif

#ifdef _NOMUTABLE
#define mutable			// Operation allowed on const object
#endif

#ifdef _NOBOOL
typedef int	bool; 		// ANSI C++ name
const bool 	false = 0;	// ANSI C++
const bool 	true  = 1;	// ANSI C++
#endif

/*----------------------------------------------------------------------------
    Modifiers for class, function, and data declarations
---------------------------------------------------------------------------*/

#ifdef _TLXDLL          // Building or using DLL version of TLX
    #ifdef _TLXBUILD
        #define _TLXCLASS       _ExportClass
        #define _TLXFUNC        _ExportFunc
        #define _TLXDATA        _ExportData
    #else
        #define _TLXCLASS       _ImportClass
        #define _TLXFUNC        _ImportFunc
        #define _TLXDATA        _ImportData
    #endif
    #if defined(_MEM_SEG) && !defined(_DATA_FAR)
        #error DLLs are only supported with FAR data models
    #endif
#else                   // Building or using static version of TLX
    #define _TLXCLASS
    #define _TLXFUNC
    #define _TLXDATA
#endif

/*----------------------------------------------------------------------------
    Typedefs and type characteristics that are platform dependent.
---------------------------------------------------------------------------*/

#if OS_DOSXXX || OS_MAC || OS_OS2 || OS_WINXXX
  #ifdef __BORLANDC__
    #include <systypes.h>
  #else
    typedef signed char         int8;
    typedef signed short        int16;
    typedef signed long         int32;
    typedef unsigned char       uint8;
    typedef unsigned short      uint16;
    typedef unsigned long       uint32;
  #endif
#elif defined(__SUNPRO_CC)
    typedef signed char         int8;
    typedef signed short        int16;
    typedef signed long         int32;
    typedef signed long long    int64;
    typedef unsigned char       uint8;
    typedef unsigned short      uint16;
    typedef unsigned long       uint32;
    typedef unsigned long long  uint64;
#else
    #error Unknown target platform; contact Tarma Software Research
#endif

typedef int             index_t;         // Used for indexing
typedef int             result_t;        // Function result; 0 = no error

typedef uint8          	byte_t;          // BYTE  = 8-bit unsigned
typedef uint16         	word_t;          // WORD  = 16 bit unsigned
typedef uint32         	dword_t;         // DWORD = 32-bit unsigned

// For backward compatibility, define the following:

typedef int8		tInt8;
typedef int16		tInt16;
typedef int32		tInt32;
typedef uint8		tUint8;
typedef uint16		tUint16;
typedef uint32		tUint32;
typedef size_t		tSize;
typedef bool		tBool;
typedef byte_t		tByte;
typedef word_t		tWord;
typedef dword_t		tDword;
typedef index_t		tIndex;
typedef result_t	tResult;

// The following union combines several commonly used iterator types

union iter_t {
    void *      ptr;
    index_t      ix;
};

// Structs and unions to access bytes in multiple-byte quantities;
// platform-independent.

struct TL2Bytes {
  #ifdef _LENDIAN
    byte_t       b0;                     // Least significant
    byte_t       b1;                     // Most significant
  #else
    byte_t       b1;                     // Most significant
    byte_t       b0;                     // Least significant
  #endif
};

struct TL4Bytes {
  #ifdef _LENDIAN
    byte_t       b0;                     // Least significant
    byte_t       b1;
    byte_t       b2;
    byte_t       b3;                     // Most significant
  #else
    byte_t       b3;                     // Most significant
    byte_t       b2;
    byte_t       b1;
    byte_t       b0;                     // Least significant
  #endif
};

struct TL2Words {
  #ifdef _LENDIAN
    word_t       w0;                     // Least significant
    word_t       w1;                     // Most significant
  #else
    word_t       w1;                     // Most significant
    word_t       w0;                     // Least significant
  #endif
};

union TLWordMap {
    word_t       w;
    TL2Bytes     b;
};

union TLDwordMap {
    TL2Words     w;
    TL4Bytes     b;
};

// Macros to map integers, allowing access to individual bytes

#define _MAP_WORD(w)    (*(TLWordMap *)&w)
#define _MAP_DWORD(d)   (*(TLDwordMap *)&d)

#define WORD_LSB(w)     (_MAP_WORD(w).b.b0)
#define WORD_MSB(w)     (_MAP_WORD(w).b.b1)

#define DWORD_LSB(d)    (_MAP_DWORD(d).b.b0)
#define DWORD_MSB(d)    (_MAP_DWORD(d).b.b3)
#define DWORD_B0(d)     (_MAP_DWORD(d).b.b0)
#define DWORD_B1(d)     (_MAP_DWORD(d).b.b1)
#define DWORD_B2(d)     (_MAP_DWORD(d).b.b2)
#define DWORD_B3(d)     (_MAP_DWORD(d).b.b3)

#define DWORD_LSW(d)    (_MAP_DWORD(d).w.w0)
#define DWORD_MSW(d)    (_MAP_DWORD(d).w.w1)

/*----------------------------------------------------------------------------
    Manifest constants
----------------------------------------------------------------------------*/

#ifndef NULL
#define NULL    0
#endif

const size_t kMaxSize  = (size_t)(-1);
const size_t kMaxAlloc = kMaxSize - 16u;

/*----------------------------------------------------------------------------
    TLX -

    Class that contains information about the library. This information
    is available through static member functions.

    The class also contains a special constructor, that serves to detect
    compilation/linking mismatches. In conjunction with a global object
    that will be included in every module that #includes this file, it will
    cause the linker to complain if you link with a different version of
    TLX than your compiler saw. This whole detection process is automatic.
----------------------------------------------------------------------------*/

class _TLXCLASS TLX
{
    static const char *	sTimeStamp;

public:
    // The following functions are statics, and are therefore available
    // without constructing an object of this class. They return information
    // about the library for use at runtime.

    static word_t	Version();	// Returns version number
    static const char *	Platform();	// Platform description
    static const char *	Model();	// Memory model description
    static const char *	Compiler();	// Compiler description
    static const char *	Description();	// Complete description
    static const char *	TimeStamp();	// Timestamp of library build
    static const char *	Maturity();	// Maturity level of library release
    static bool 	IsDebug();	// Nonzero if debug version

    // Link check functions

    static int		_TLXVNAME();	// Checks version + release
    static int		_TLXDS();	// Checks DLL vs. static
    static int		_TLXDR();	// Checks debug vs. retail
};

// The following definition of a global variable will cause a copy of that
// variable to be added to each module that #includes this file.
//
// Note: if space is at a premium and you are absolutely certain that you
// link to the correct version of the library, define _NO_LINK_CHECK at
// the compiler command line, and no data space will be wasted.

#if !defined(_NO_LINK_CHECK) && !defined(_MSC_VER)  // MSVC 4.x bug
static int _gLinkCheck = TLX::_TLXVNAME() + TLX::_TLXDS() + TLX::_TLXDR();
//lint -esym(528,_gLinkCheck)	Do not complain about not being referenced
#endif

#endif  // _TLX_TLX_H
