/****************************************************************************
    $Id: think.h 501.0 1995/03/07 12:26:48 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    (Symantec) THINK-specific declarations of compilation and keyword-like
    names.

    $Log: think.h $
    Revision 501.0  1995/03/07 12:26:48  RON
    Updated for TLX 5.01
    Revision 1.5  1995/01/31 16:32:16  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.4  1995/01/18  18:56:00  ron
    Added support for _GUI preprocessor name

    Revision 1.3  1994/11/16  15:23:34  ron
    Added _CCNAME, _CCVER, and _MODEL definitions

    Revision 1.2  1994/10/06  17:50:00  ron
    Added _NOMUTABLE

    Revision 1.1  1994/08/16  18:06:54  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_THINK_H
#define _TLX_THINK_H

#if !defined(THINK_C) && !defined(THINK_CPLUS)
#error This file is for Symantec/THINK compilations only
#endif

#define _CCNAME		THINK C++
#define _CCVER	       	THINK_CPLUS

#define _NORTTI		1
#define _NOEXCEPT	1
#define _NOBOOL		1
#define _NOMUTABLE	1

#define _GUI		1

#define _Near
#define _Far
#define _Huge
#define _MODEL		Flat

#define _ExportClass
#define _ExportFunc
#define _ExportData

#define _ImportClass
#define _ImportFunc
#define _ImportData

#ifdef THINK_C

    /* Make sure that we use 4-byte integers under THINK C for compatibility
     * with Symantec C++. We could do that silently with:
     *
     *	    #pragma option(int_4)
     *
     * but this might be missed by casual users.
     */
    #if !__option(int_4)
    #error THINK C users: compile your code with 4-byte integers
    #endif

#endif

/*---------------------------------------------------------------------------
    Symantec C++ 6.0 for Macintosh additional functions
---------------------------------------------------------------------------*/

char *		strdup(const char *);

#endif	/* _TLX_THINK_H */

