/****************************************************************************
    $Id: vector.cpp 501.0 1995/03/07 12:27:04 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLVector<T>.

    $Log: vector.cpp $
    Revision 501.0  1995/03/07 12:27:04  RON
    Updated for TLX 5.01
    Revision 1.5  1995/01/31 16:30:54  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.4  1994/09/28  14:43:22  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:27:51  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:37:29  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:15:37  ron
    Initial revision

****************************************************************************/

#ifndef __VECTOR_CPP
#define __VECTOR_CPP

//----- Project headers

#ifndef _TLX_ARRAYS_H
#include <tlx\501\arrays.h>
#endif

#ifndef _TLX_VBASE_CPP
#include <tlx\501\template\vbase.cpp>
#endif

/*-------------------------------------------------------------------------*/
    template<class T> TLVector<T>::TLVector(size_t size)

/*  Constructor creating a vector with the given size.
---------------------------------------------------------------------------*/
: TLVBase<T>(size)
{
}

/*-------------------------------------------------------------------------*/
    template<class T> TLVector<T>::TLVector(const T &t)

/*  Constructor creating a vector consisting of a single element.
---------------------------------------------------------------------------*/
: TLVBase<T>(t)
{
}

/*-------------------------------------------------------------------------*/
    template<class T> TLVector<T>::TLVector(const T *t, size_t sz)

/*  Constructor creating a vector that is a copy of a C-style vector of
    a given size.
---------------------------------------------------------------------------*/
: TLVBase<T>(t, sz)
{
}

/*-------------------------------------------------------------------------*/
    template<class T>
    TLVector<T> &TLVector<T>::operator =(const TLVector<T> &s)

/*  Overloading of the assignment operator.
---------------------------------------------------------------------------*/
{
    if (this != &s)
	TLVBase<T>::operator =(s);
    return *this;
}

#endif	// __VECTOR_CPP
