/****************************************************************************
    $Id: vectiter.cpp 501.0 1995/03/07 12:27:04 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of vector iterator templates:

    - TLVectorIter
    - TLVectorIterConst

    $Log: vectiter.cpp $
    Revision 501.0  1995/03/07 12:27:04  RON
    Updated for TLX 5.01
    Revision 1.4  1995/01/31 16:30:54  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.3  1994/10/06  17:52:09  ron
    Changed #defined name

    Revision 1.2  1994/09/27  20:27:49  ron
    Changed path separator from / to \

    Revision 1.1  1994/09/26  15:37:15  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_VECTITER_CPP
#define _TLX_VECTITER_CPP

#ifndef _TLX_VALITER_CPP
#include <tlx\501\template\valiter.cpp>
#endif

/*-------------------------------------------------------------------------*/
    template<class T> TLVectorIter<T>::TLVectorIter(T aVector[], size_t aSize)

/*  Constructor. Links to the given C-style vector.
---------------------------------------------------------------------------*/
{
    mVector = aVector;
    mSize   = aSize;
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLVectorIter<T>::FirstPos()

/*  Sets the iterator to the first available position (if any), returning
    true if that move succeeds.
---------------------------------------------------------------------------*/
{
    mPos = 0;
    return mPos < mSize;
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLVectorIter<T>::NextPos()

/*  Advances the iterator to the next available position (if any), returning
    true if that move succeeds.
---------------------------------------------------------------------------*/
{
    return ++mPos < mSize;
}

/*-------------------------------------------------------------------------*/
    template<class T> T &TLVectorIter<T>::Peek() const

/*  Returns a reference to the currently iterated element.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(IsValid());
    TLX_ASSERT(mPos < mSize);

    return mVector[mPos];
}

/*-------------------------------------------------------------------------*/
    template<class T> TLVectorIterConst<T>::TLVectorIterConst
    (
    	const T 	aVector[],
	size_t 		aSize
    )

/*  Constructor. Links to the given C-style vector.
---------------------------------------------------------------------------*/
{
    mVector = aVector;
    mSize   = aSize;
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLVectorIterConst<T>::FirstPos()

/*  Sets the iterator to the first available position (if any), returning
    true if that move succeeds.
---------------------------------------------------------------------------*/
{
    mPos = 0;
    return mPos < mSize;
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLVectorIterConst<T>::NextPos()

/*  Advances the iterator to the next available position (if any), returning
    true if that move succeeds.
---------------------------------------------------------------------------*/
{
    return ++mPos < mSize;
}

/*-------------------------------------------------------------------------*/
    template<class T> const T &TLVectorIterConst<T>::Peek() const

/*  Returns a reference to the currently iterated element.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(IsValid());
    TLX_ASSERT(mPos < mSize);

    return mVector[mPos];
}

#endif	// _TLX_VECTITER_CPP
