/****************************************************************************
    $Id: valiter.cpp 501.0 1995/03/07 12:27:02 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of value iterator templates:

    - TLValueIter
    - TLValueIterConst

    $Log: valiter.cpp $
    Revision 501.0  1995/03/07 12:27:02  RON
    Updated for TLX 5.01
    Revision 1.6  1995/01/31 16:30:52  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.5  1994/11/16  15:34:19  ron
    #included <iostream.h>

    Revision 1.4  1994/10/12  10:10:53  ron
    Implemented Contains() member functions

    Revision 1.3  1994/10/06  17:51:57  ron
    Changed #defined name

    Revision 1.2  1994/09/27  20:27:45  ron
    Changed path separator from / to \

    Revision 1.1  1994/09/26  15:36:36  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_VALITER_CPP
#define _TLX_VALITER_CPP

#include <iostream.h>

#ifndef _TLX_DEBUG_H
#include <tlx\501\debug.h>
#endif
#ifndef _TLX_ITER_H
#include <tlx\501\iter.h>
#endif

/*-------------------------------------------------------------------------*/
    template<class T> bool TLValueIter<T>::Contains(T &aValue)

/*  Checks whether the given value is contained in the associated
    collection. This will change the state of the iterator.
---------------------------------------------------------------------------*/
{
    for (Reset(); Next(); )
	if (Peek() == aValue)
	    return true;
    return false;
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLValueIter<T>::FirstThat
    (
    	tTestFunc 	aTest,		// Test to perform
	void *		aArg,		// Optional argument
	T *&		aSuccess	// First element that succeeds
    )

/*  Applies a given test function to elements of the associated collection
    until the test returns true. It then sets 'aSuccess' to point to the
    element that first made the test succeed and returns true. If all
    elements fail the test, false is returned and 'aSuccess' is not changed.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aTest);

    for (Reset(); Next(); )
	if ((*aTest)(Peek(), aArg))
	{
	    aSuccess = &Peek();
	    return true;
	}
    return false;
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLValueIter<T>::FirstThatNot
    (
    	tTestFunc 	aTest, 		// Test to apply
	void *		aArg,   	// Optional argument
	T *&		aFailure	// First element that fails
    )

/*  Applies a given test function to elements in the associated collection
    as long as the test succeeds. It then sets 'aFailure' to point to the
    element that first made the test fail and returns true.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aTest);

    for (Reset(); Next(); )
	if (!(*aTest)(Peek(), aArg))
	{
	    aFailure = &Peek();
	    return true;
	}
    return false;
}

/*-------------------------------------------------------------------------*/
    template<class T> void TLValueIter<T>::ForAll(tApplyFunc aFunc,void *aArg)

/*  Applies a given function to all elements in the associated collection.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aFunc);

    for (Reset(); Next(); )
	(*aFunc)(Peek(), aArg);
}

/*-------------------------------------------------------------------------*/
    template<class T> ostream &TLValueIter<T>::PrintAll(ostream &os)

/*  Prints all elements in the associated collection without any formatting.
    This function assumes the existence of operator <<(ostream &, const T &).
---------------------------------------------------------------------------*/
{
    return PrintFormat(os, TLPrintFormat());
}

/*-------------------------------------------------------------------------*/
    template<class T> ostream &TLValueIter<T>::PrintFormat
    (
    	ostream &		os,
	const TLPrintFormat &	aFmt
    )

/*  Prints all elements in the associated collection with the given
    formatting around the collection and its elements. This function
    assumes the existence of operator <<(ostream &, const T &).
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aFmt.mLeader);
    TLX_ASSERT_PTR(aFmt.mPresep);
    TLX_ASSERT_PTR(aFmt.mPostsep);
    TLX_ASSERT_PTR(aFmt.mTrailer);

    os << aFmt.mLeader;
    for (Reset(); Next(); )
	os << aFmt.mPresep << Peek() << aFmt.mPostsep;

    return os << aFmt.mTrailer;
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLValueIterConst<T>::Contains(const T &aValue)

/*  Checks whether the given value is contained in the associated
    collection. This will change the state of the iterator.
---------------------------------------------------------------------------*/
{
    for (Reset(); Next(); )
	if (Peek() == aValue)
	    return true;
    return false;
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLValueIterConst<T>::FirstThat
    (
    	tTestFunc 	aTest,		// Test to perform
	void *		aArg,		// Optional argument
	const T *&	aSuccess	// First element that succeeds
    )

/*  Applies a given test function to elements of the associated collection
    until the test returns true. It then sets 'aSuccess' to point to the
    element that first made the test succeed and returns true. If all
    elements fail the test, false is returned and 'aSuccess' is not changed.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aTest);

    for (Reset(); Next(); )
	if ((*aTest)(Peek(), aArg))
	{
	    aSuccess = &Peek();
	    return true;
	}
    return false;
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLValueIterConst<T>::FirstThatNot
    (
    	tTestFunc 	aTest, 		// Test to apply
	void *		aArg,   	// Optional argument
	const T *&	aFailure	// First element that fails
    )

/*  Applies a given test function to elements in the associated collection
    as long as the test succeeds. It then sets 'aFailure' to point to the
    element that first made the test fail and returns true.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aTest);

    for (Reset(); Next(); )
	if (!(*aTest)(Peek(), aArg))
	{
	    aFailure = &Peek();
	    return true;
	}
    return false;
}

/*-------------------------------------------------------------------------*/
    template<class T> void TLValueIterConst<T>::ForAll
    (
    	tApplyFunc 	aFunc,		// Function to apply
	void *		aArg		// Optional argument pointer
    )

/*  Applies a given function to all elements in the associated collection.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aFunc);

    for (Reset(); Next(); )
	(*aFunc)(Peek(), aArg);
}

/*-------------------------------------------------------------------------*/
    template<class T> ostream &TLValueIterConst<T>::PrintAll(ostream &os)

/*  Prints all elements in the associated collection without any formatting.
    This function assumes the existence of operator <<(ostream &, const T &).
---------------------------------------------------------------------------*/
{
    return PrintFormat(os, TLPrintFormat());
}

/*-------------------------------------------------------------------------*/
    template<class T> ostream &TLValueIterConst<T>::PrintFormat
    (
    	ostream &		os,
	const TLPrintFormat &	aFmt
    )

/*  Prints all elements in the associated collection with the given
    formatting around the collection and its elements. This function
    assumes the existence of operator <<(ostream &, const T &).
---------------------------------------------------------------------------*/
{
    TLX_ASSERT_PTR(aFmt.mLeader);
    TLX_ASSERT_PTR(aFmt.mPresep);
    TLX_ASSERT_PTR(aFmt.mPostsep);
    TLX_ASSERT_PTR(aFmt.mTrailer);

    os << aFmt.mLeader;
    for (Reset(); Next(); )
	os << aFmt.mPresep << Peek() << aFmt.mPostsep;
    return os << aFmt.mTrailer;
}

#endif	// _TLX_VALITER_CPP
