/****************************************************************************
    $Id: stack.cpp 501.0 1995/03/07 12:27:02 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLStack<T>.

    $Log: stack.cpp $
    Revision 501.0  1995/03/07 12:27:02  RON
    Updated for TLX 5.01
    Revision 1.5  1995/01/31 16:30:52  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.4  1994/09/28  14:42:57  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:27:43  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:36:21  ron
    hanged include file references

    Revision 1.1  1994/08/16  18:15:35  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_STACK_CPP
#define _TLX_STACK_CPP

//----- Project headers

#ifndef _TLX_ARRAYS_H
#include <tlx\501\arrays.h>
#endif
#ifndef _TLX_DEBUG_H
#include <tlx\501\debug.h>
#endif
#ifndef _TLX_EXCEPT_H
#include <tlx\501\except.h>
#endif

#ifndef _TLX_SEQBASE_CPP
#include <tlx\501\template\seqbase.cpp>
#endif

/*-------------------------------------------------------------------------*/
    template<class T> TLStack<T>::TLStack(size_t size, size_t delta)

/*  Constructor creating a stack with the given initial capacity and
    expansion factor.
---------------------------------------------------------------------------*/
: TLSeqBase<T>(size, delta)
{
}

/*-------------------------------------------------------------------------*/
    template<class T> TLStack<T>::TLStack(const T &t)

/*  Constructor creating a stack which holds a single element. The stack
    is not expandable initially.
---------------------------------------------------------------------------*/
: TLSeqBase<T>(t)
{
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLStack<T>::IterFirst(iter_t &i) const

/*  Initializes the iterator to address the first (topmost) element of the
    stack. Returns nonzero if the iterator is valid after the operation,
    else zero.
---------------------------------------------------------------------------*/
{
    return (i.ix = mCount - 1) >= 0;
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLStack<T>::IterLast(iter_t &i) const

/*  Initializes the iterator to address the last (bottommost) element of the
    stack. Returns nonzero if the iterator is valid after the operation,
    else zero.
---------------------------------------------------------------------------*/
{
    return (i.ix = 0) < mCount;
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLStack<T>::IterNext(iter_t &i) const

/*  Advances the iterator to address the next (bottomward) element of the
    stack. Returns nonzero if the iterator is valid after the operation,
    else zero.
---------------------------------------------------------------------------*/
{
    return --i.ix >= 0;
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLStack<T>::IterPrev(iter_t &i) const

/*  Advances the iterator to address the previous (topward) element of the
    stack. Returns nonzero if the iterator is valid after the operation,
    else zero.
---------------------------------------------------------------------------*/
{
    return ++i.ix < mCount;
}


/*-------------------------------------------------------------------------*/
    template<class T> TLStack<T> &TLStack<T>::operator =(const T &t)

/*  Overloading of the assignment operator that allows assignment of a
    single element to the stack. The previous stack contents are lost.
---------------------------------------------------------------------------*/
{
    RemoveAll();
    Push(t);
    return *this;
}

/*-------------------------------------------------------------------------*/
    template<class T> TLStack<T> &TLStack<T>::operator =(const TLStack<T> &s)

/*  Overloading of the assignment operator.
---------------------------------------------------------------------------*/
{
    if (this != &s)
	TLSeqBase<T>::operator =(s);
    return *this;
}

/*-------------------------------------------------------------------------*/
    template<class T> T TLStack<T>::Pop()

/*  Removes and returns the topmost element of the stack. If the stack is
    empty, a TLXEmpty exception is thrown.
---------------------------------------------------------------------------*/
{
    if (IsEmpty())
	THROW(TLXEmpty(LOCUS));

    return mVect[--mCount];
}

/*-------------------------------------------------------------------------*/
    template<class T> void TLStack<T>::Push(const T &t)

/*  Adds a new element to the top of the stack.
---------------------------------------------------------------------------*/
{
    if (IsFull())
    	Expand();

    TLX_ASSERT(Available() >= 1);

    mVect[mCount++] = t;
}

/*-------------------------------------------------------------------------*/
    template<class T> T &TLStack<T>::PeekTop()

/*  Returns a reference to the topmost element of the stack. If the stack
    is empty, a TLXEmpty exception is thrown.
---------------------------------------------------------------------------*/
{
    if (IsEmpty())
	THROW(TLXEmpty(LOCUS));

    return mVect[mCount - 1];
}

/*-------------------------------------------------------------------------*/
    template<class T> const T &TLStack<T>::PeekTop() const

/*  Returns a reference to the topmost element of the stack. If the stack
    is empty, a TLXEmpty exception is thrown.
---------------------------------------------------------------------------*/
{
    if (IsEmpty())
	THROW(TLXEmpty(LOCUS));

    return mVect[mCount - 1];
}

/*-------------------------------------------------------------------------*/
    template<class T> void TLStack<T>::RemoveTop()

/*  Removes the topmost element of the stack. If the stack is empty, a
    TLXEmpty exception is thrown.
---------------------------------------------------------------------------*/
{
    if (IsEmpty())
	THROW(TLXEmpty(LOCUS));

    TLX_ASSERT(mCount > 0);
    --mCount;
}

#endif	// _TLX_STACK_CPP
