/****************************************************************************
    $Id: seqbase.cpp 501.0 1995/03/07 12:27:00 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Imlementation of class TLSeqBase<T>.

    $Log: seqbase.cpp $
    Revision 501.0  1995/03/07 12:27:00  RON
    Updated for TLX 5.01
    Revision 1.5  1995/01/31 16:30:50  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.4  1994/09/28  14:42:11  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:27:36  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:34:35  ron
    Changed include file references
    Renamed SetSize() to Resize()

    Revision 1.1  1994/08/16  18:15:32  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_SEQBASE_CPP
#define _TLX_SEQBASE_CPP

//----- Project headers

#ifndef _TLX_ARRAYS_H
#include <tlx\501\arrays.h>
#endif
#ifndef _TLX_DEBUG_H
#include <tlx\501\debug.h>
#endif
#ifndef _TLX_EXCEPT_H
#include <tlx\501\except.h>
#endif

#ifndef _TLX_VBASE_CPP
#include <tlx\501\template\vbase.cpp>
#endif

/*-------------------------------------------------------------------------*/
    template<class T> TLSeqBase<T>::TLSeqBase(size_t size, size_t delta)

/*  Normal constructor for TLSeqBase<T>. It calls the TLVector<T>(size_t)
    constructor to create a vector of the desired size, then it sets
    mCount to 0 to indicate an empty sequence, and mDelta to the
    delta parameter.
---------------------------------------------------------------------------*/
: TLVBase<T>(size)
{
    mCount = 0;
    mDelta = delta;
}

/*-------------------------------------------------------------------------*/
    template<class T> TLSeqBase<T>::TLSeqBase(const T &t)

/*  Constructor creating a single element sequence.
---------------------------------------------------------------------------*/
: TLVBase<T>(t)
{
    mDelta = 0;
    mCount = mSize;
}

/*-------------------------------------------------------------------------*/
    template<class T> TLSeqBase<T>::TLSeqBase(const T *tp, size_t sz)

/*  Constructor creating a sequence from a C-style vector of given size.
---------------------------------------------------------------------------*/
: TLVBase<T>(tp, sz)
{
    mDelta = 0;
    mCount = mSize;
}

/*-------------------------------------------------------------------------*/
    template<class T> void TLSeqBase<T>::CompactStorage()

/*  Adjusts the physical storage to fit the logical size of the sequence.
---------------------------------------------------------------------------*/
{
    Resize(Count());
}

/*-------------------------------------------------------------------------*/
    template<class T> void TLSeqBase<T>::Expand()

/*  Expands the storage for the sequence by mDelta elements. If mDelta is
    0, or expansion fails otherwise, a TLXFull exception is thrown.
---------------------------------------------------------------------------*/
{
    if (mDelta < 1)
	THROW(TLXFull(LOCUS));

    ExpandBy(mDelta);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLSeqBase<T> &TLSeqBase<T>::operator =
    (
    	const TLSeqBase<T> &s
    )

/*  Overloading of assignment operator.
---------------------------------------------------------------------------*/
{
    if (this != &s)
    {
	TLVBase<T>::operator =(s);
	mCount = s.mCount;
	mDelta = s.mDelta;
    }
    return *this;
}

/*-------------------------------------------------------------------------*/
    template<class T> size_t TLSeqBase<T>::SetDelta(size_t dt)

/*  Sets the expansion parameter, returning its previous value.
---------------------------------------------------------------------------*/
{
    size_t del = mDelta;
    mDelta = dt;
    return del;
}

#endif	// _TLX_SEQBASE_CPP

