/****************************************************************************
    $Id: safeptr.cpp 501.0 1995/03/07 12:27:00 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLSafePointer<T>.

    $Log: safeptr.cpp $
    Revision 501.0  1995/03/07 12:27:00  RON
    Updated for TLX 5.01
    Revision 1.6  1995/01/31 16:30:48  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.5  1994/09/28  14:41:46  ron
    Removed Macintosh-style #include references

    Revision 1.4  1994/09/27  20:27:31  ron
    Changed path separator from / to \

    Revision 1.3  1994/09/26  15:34:08  ron
    Changed include file references

    Revision 1.2  1994/09/06  14:16:07  ron
    adapted to change from TLRef to TLRefCount

    Revision 1.1  1994/08/16  18:15:31  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_SAFEPTR_CPP
#define _TLX_SAFEPTR_CPP

//----- Project headers

#ifndef _TLX_REFPTR_H
#include <tlx\501\refcnt.h>
#endif

/*-------------------------------------------------------------------------*/
    template<class T> TLSafePointer<T>::TLSafePointer()

/*  Default constructor. Relies on the default constructor inherited
    from class TLRefHnd. We need to provide it, though, because the
    compiler will not generate a default constructor in the presence
    of other explicitly declared constructors.
---------------------------------------------------------------------------*/
: TLRefHnd()	// Superfluous really
{
}

/*-------------------------------------------------------------------------*/
    template<class T> TLSafePointer<T>::TLSafePointer(T *aPtr)

/*  Constructor that provides conversion from ordinary T pointers.
---------------------------------------------------------------------------*/
: TLRefHnd(aPtr)
{
}

#endif	// _TLX_SAFEPTR_CPP
