/****************************************************************************
    $Id: ptrvect.cpp 501.0 1995/03/07 12:27:00 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLPtrVector<T>.

    $Log: ptrvect.cpp $
    Revision 501.0  1995/03/07 12:27:00  RON
    Updated for TLX 5.01
    Revision 1.5  1995/01/31 16:30:46  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.4  1994/09/28  14:41:27  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:27:27  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:33:40  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:15:29  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_PTRVECT_CPP
#define _TLX_PTRVECT_CPP

//----- System headers

//----- Project headers

#ifndef _TLX_PTRARRAY_H
#include <tlx\501\ptrarray.h>	// Class declaration
#endif

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrVector<T>::TLPtrVector(size_t aSize)

/*  Constructor to create vector of specified size; also doubles as default
    constructor.
---------------------------------------------------------------------------*/
: TLVPVector(aSize)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrVector<T>::TLPtrVector(T *aPtr)

/*  Constructor that initializes a vector of 1 element.
---------------------------------------------------------------------------*/
: TLVPVector(aPtr)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrVector<T>::TLPtrVector(T **aVector, size_t aSize)

/*  Constructor that initializes a vector from a corresponding C-style
    vector.
---------------------------------------------------------------------------*/
: TLVPVector((void **)aVector, aSize)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrVector<T>::TLPtrVector
    (
    	const TLPtrVector<T> &	aVector
    )

/*  Copy constructor.
---------------------------------------------------------------------------*/
: TLVPVector(aVector)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> void TLPtrVector<T>::DeleteT(void *aPtr)

/*  Static member function that is used for deletion of T * elements
    in vectors and the like.
---------------------------------------------------------------------------*/
{
    delete (T *)aPtr;
}

#endif	// _TLX_PTRVECT_CPP
