/****************************************************************************
    $Id: ptrstack.cpp 501.0 1995/03/07 12:27:00 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLPtrStack<T>.

    $Log: ptrstack.cpp $
    Revision 501.0  1995/03/07 12:27:00  RON
    Updated for TLX 5.01
    Revision 1.5  1995/01/31 16:30:46  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.4  1994/09/28  14:41:20  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:27:26  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:33:29  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:15:29  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_PTRSTACK_CPP
#define _TLX_PTRSTACK_CPP

//----- System headers

//----- Project headers

#ifndef _TLX_PTRARRAY_H
#include <tlx\501\ptrarray.h>	// Class declaration
#endif

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrStack<T>::TLPtrStack(size_t aSize, size_t aDelta)

/*  Constructor to create stack of specified size; also doubles as default
    constructor.
---------------------------------------------------------------------------*/
: TLVPStack(aSize, aDelta)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrStack<T>::TLPtrStack(T *aPtr)

/*  Constructor that initializes a stack of 1 element.
---------------------------------------------------------------------------*/
: TLVPStack(aPtr)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrStack<T>::TLPtrStack(T **aStack, size_t aSize)

/*  Constructor that initializes a stack from a corresponding C-style
    vector.
---------------------------------------------------------------------------*/
: TLVPStack((void **)aStack, aSize)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrStack<T>::TLPtrStack(const TLPtrStack<T> &aStack)

/*  Copy constructor.
---------------------------------------------------------------------------*/
: TLVPStack(aStack)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> void TLPtrStack<T>::DeleteT(void *aPtr)

/*  Deletes pointed to object, after the appropriate typecast.
---------------------------------------------------------------------------*/
{
    delete (T *)aPtr;
}

#endif	// _TLX_PTRSTACK_CPP
