/****************************************************************************
    $Id: ptrset.cpp 501.0 1995/03/07 12:27:00 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLPtrSet<T>.

    $Log: ptrset.cpp $
    Revision 501.0  1995/03/07 12:27:00  RON
    Updated for TLX 5.01
    Revision 1.5  1995/01/31 16:30:46  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.4  1994/10/06  17:51:23  ron
    Changed #defined name

    Revision 1.3  1994/09/27  20:27:24  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:33:18  ron
    Implemented iterators

    Revision 1.1  1994/08/16  18:15:28  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_PTRSET_CPP
#define _TLX_PTRSET_CPP

//----- Project headers

#ifndef _TLX_PTRARRAY_H
#include <tlx\501\debug.h>
#endif
#ifndef _TLX_PTRARRAY_H
#include <tlx\501\ptrarray.h>
#endif

#ifndef _TLX_PTRITER_CPP
#include <tlx\501\template\ptriter.cpp>
#endif

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrSetIter<T>::TLPtrSetIter(TLPtrSet<T> &aSet)

/*  Constructor. Links to the given set.
---------------------------------------------------------------------------*/
: mSet(aSet)
{
}

/*-------------------------------------------------------------------------*/
    template<class T> size_t TLPtrSetIter<T>::Count() const

/*  Returns the number of items in the associated collection
---------------------------------------------------------------------------*/
{
    return mSet.Count();
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLPtrSetIter<T>::FirstPos()

/*  Sets the iterator to the first position (if any), returning true
    on success.
---------------------------------------------------------------------------*/
{
    mPos = mSet.Mini();
    return mPos <= mSet.Maxi();
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLPtrSetIter<T>::NextPos()

/*  Advances the iterator to the next position (if any), returning true
    on success.
---------------------------------------------------------------------------*/
{
    if (mPos < mSet.Maxi())	// Test first to avoid integer overflow
    {
	mPos++;
	return true;
    }
    else
	return false;
}

/*-------------------------------------------------------------------------*/
    template<class T> T *&TLPtrSetIter<T>::Peek() const

/*  Returns the current iteration element.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(IsValid());
    return mSet.PeekAt(mPos);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrSetIterConst<T>::TLPtrSetIterConst
    	(TLPtrSet<T> &aSet)

/*  Constructor. Links to the given set.
---------------------------------------------------------------------------*/
: mSet(aSet)
{
}

/*-------------------------------------------------------------------------*/
    template<class T> size_t TLPtrSetIterConst<T>::Count() const

/*  Returns the number of items in the associated collection
---------------------------------------------------------------------------*/
{
    return mSet.Count();
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLPtrSetIterConst<T>::FirstPos()

/*  Sets the iterator to the first position (if any), returning true
    on success.
---------------------------------------------------------------------------*/
{
    mPos = mSet.Mini();
    return mPos <= mSet.Maxi();
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLPtrSetIterConst<T>::NextPos()

/*  Advances the iterator to the next position (if any), returning true
    on success.
---------------------------------------------------------------------------*/
{
    if (mPos < mSet.Maxi())	// Test first to avoid integer overflow
    {
	mPos++;
	return true;
    }
    else
	return false;
}

/*-------------------------------------------------------------------------*/
    template<class T> T *TLPtrSetIterConst<T>::Peek() const

/*  Returns the current iteration element.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(IsValid());
    return mSet.PeekAt(mPos);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrSet<T>::TLPtrSet(size_t aSize, size_t aDelta)

/*  Constructor to create set of specified size; also doubles as default
    constructor.
---------------------------------------------------------------------------*/
: TLVPSet(aSize, aDelta)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrSet<T>::TLPtrSet(T *aPtr)

/*  Constructor that initializes a set of 1 element.
---------------------------------------------------------------------------*/
: TLVPSet(aPtr)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrSet<T>::TLPtrSet(const TLPtrSet<T> &aSet)

/*  Copy constructor.
---------------------------------------------------------------------------*/
: TLVPSet(aSet)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> void TLPtrSet<T>::DeleteT(void *aPtr)

/*  Deletes pointed to object, after the appropriate typecast.
---------------------------------------------------------------------------*/
{
    delete (T *)aPtr;
}

#endif	// _TLX_PTRSET_CPP
