/****************************************************************************
    $Id: ptrseq.cpp 501.0 1995/03/07 12:26:58 RON Exp $

    Copyright (c) 1993-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLPtrSeq<T>

    $Log: ptrseq.cpp $
    Revision 501.0  1995/03/07 12:26:58  RON
    Updated for TLX 5.01
    Revision 1.7  1995/01/31 16:31:52  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.6  1994/10/06  17:51:16  ron
    Changed #defined name

    Revision 1.5  1994/10/05  18:49:34  ron
    Added constructor that accepts an iterator

    Revision 1.4  1994/09/28  14:30:40  ron
    Fixed spelling of mSet to mSeq in TLPtrSeq iterators

    Revision 1.3  1994/09/27  20:27:22  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:32:49  ron
    Implemented iterators

    Revision 1.1  1994/08/16  18:15:28  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_PTRSEQ_CPP
#define _TLX_PTRSEQ_CPP

//----- Project headers

#ifndef _TLX_DEBUG_H
#include <tlx\501\debug.h>
#endif
#ifndef _TLX_EXCEPT_H
#include <tlx\501\except.h>
#endif
#ifndef _TLX_PTRARRAY_H
#include <tlx\501\ptrarray.h>
#endif

#ifndef _TLX_PTRITER_CPP
#include <tlx\501\template\ptriter.cpp>
#endif

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrSeqIter<T>::TLPtrSeqIter(TLPtrSeq<T> &aSeq)

/*  Constructor. Links to the given set.
---------------------------------------------------------------------------*/
: mSeq(aSeq)
{
}

/*-------------------------------------------------------------------------*/
    template<class T> size_t TLPtrSeqIter<T>::Count() const

/*  Returns the number of items in the associated collection.
---------------------------------------------------------------------------*/
{
    return mSeq.Count();
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLPtrSeqIter<T>::FirstPos()

/*  Sets the iterator to the first position (if any), returning true
    on success.
---------------------------------------------------------------------------*/
{
    mPos = mSeq.Mini();
    return mPos <= mSeq.Maxi();
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLPtrSeqIter<T>::NextPos()

/*  Advances the iterator to the next position (if any), returning true
    on success.
---------------------------------------------------------------------------*/
{
    if (mPos < mSeq.Maxi()) {	// Test first to avoid integer overflow
	mPos++;
	return true;
    } else
	return false;
}

/*-------------------------------------------------------------------------*/
    template<class T> T *&TLPtrSeqIter<T>::Peek() const

/*  Returns the current iteration element.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(IsValid());
    return mSeq.PeekAt(mPos);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrSeqIterConst<T>::TLPtrSeqIterConst
    	(const TLPtrSeq<T> &aSeq)

/*  Constructor. Links to the given set.
---------------------------------------------------------------------------*/
: mSeq(aSeq)
{
}

/*-------------------------------------------------------------------------*/
    template<class T> size_t TLPtrSeqIterConst<T>::Count() const

/*  Returns the number of items in the associated collection.
---------------------------------------------------------------------------*/
{
    return mSeq.Count();
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLPtrSeqIterConst<T>::FirstPos()

/*  Sets the iterator to the first position (if any), returning true
    on success.
---------------------------------------------------------------------------*/
{
    mPos = mSeq.Mini();
    return mPos <= mSeq.Maxi();
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLPtrSeqIterConst<T>::NextPos()

/*  Advances the iterator to the next position (if any), returning true
    on success.
---------------------------------------------------------------------------*/
{
    if (mPos < mSeq.Maxi()) {	// Test first to avoid integer overflow
	mPos++;
	return true;
    } else
	return false;
}

/*-------------------------------------------------------------------------*/
    template<class T> T *TLPtrSeqIterConst<T>::Peek() const

/*  Returns the current iteration element.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(IsValid());
    return mSeq.PeekAt(mPos);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrSeq<T>::TLPtrSeq(size_t aSize, size_t aDelta)

/*  Constructor to create sequence of specified size; also doubles as
    default constructor.
---------------------------------------------------------------------------*/
: TLVPSeq(aSize, aDelta)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrSeq<T>::TLPtrSeq(T *aPtr)

/*  Constructor that initializes a sequence of 1 element.
---------------------------------------------------------------------------*/
: TLVPSeq(aPtr)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrSeq<T>::TLPtrSeq(T **aSeq, size_t aSize)

/*  Constructor that initializes a sequence from a corresponding C-style
    vector.
---------------------------------------------------------------------------*/
: TLVPSeq((void **)aSeq, aSize)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrSeq<T>::TLPtrSeq(TLPtrIter<T> &aIter)

/*  Constructor that initializes from an iterator.
---------------------------------------------------------------------------*/
: TLVPSeq(aIter.Count())
{
    SetDelete(DeleteT);
    for (aIter.Reset(); aIter.Next(); )
	Append(aIter.Peek());
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrSeq<T>::TLPtrSeq(const TLPtrSeq<T> &aSeq)

/*  Copy constructor.
---------------------------------------------------------------------------*/
: TLVPSeq(aSeq)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> void TLPtrSeq<T>::DeleteT(void *aPtr)

/*  Deletes pointed to object, after the appropriate typecast.
---------------------------------------------------------------------------*/
{
    delete (T *)aPtr;
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrSeq<T> TLPtrSeq<T>::Extract
    (
    	index_t 	aIndex,
	size_t 	aLength
    )

/*  Extracts and returns a subsequence of the current sequence.
---------------------------------------------------------------------------*/
{
    if (!IsValidIndex(aIndex))
	THROW(TLXIndex(LOCUS, aIndex));

    // Adjust number of items to remove, if necessary
    if (aLength > (Maxi() - aIndex + 1))
	aLength = Maxi() - aIndex + 1;

    // Create a copy of the subsequence, then remove the elements
    TLPtrSeq<T> vCopy(&PeekAt(aIndex), aLength);
    RemoveAt(aIndex, aLength);

    return vCopy;
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrSeq<T> TLPtrSeq<T>::ExtractFirst(size_t aLength)

/*  Extracts and returns a subsequence of the current sequence, starting at
    the beginning of the current sequence.
---------------------------------------------------------------------------*/
{
    return Extract(Mini(), aLength);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrSeq<T> TLPtrSeq<T>::ExtractLast(size_t aLength)

/*  Extracts and returns a subsequence of the current sequence, starting
    at the end of the current sequence.
---------------------------------------------------------------------------*/
{
    if (aLength > Count())
	aLength = Count();
    return Extract(Maxi() - aLength + 1, aLength);
}

#endif	// _TLX_PTRSEQ_CPP
