/****************************************************************************
    $Id: ptrqueue.cpp 501.0 1995/03/07 12:26:58 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLPtrQueue<T>.

    $Log: ptrqueue.cpp $
    Revision 501.0  1995/03/07 12:26:58  RON
    Updated for TLX 5.01
    Revision 1.6  1995/01/31 16:30:46  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.5  1994/10/05  18:49:09  ron
    Added constructor that accepts an iterator

    Revision 1.4  1994/09/28  14:41:10  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:27:21  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:32:20  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:15:27  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_PTRQUEUE_CPP
#define _TLX_PTRQUEUE_CPP

//----- System headers

//----- Project headers

#ifndef _TLX_PTRARRAY_H
#include <tlx\501\ptrarray.h>	// Class declaration
#endif

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrQueue<T>::TLPtrQueue(size_t aSize, size_t aDelta)

/*  Constructor to create queue of specified size; also doubles as default
    constructor.
---------------------------------------------------------------------------*/
: TLVPQueue(aSize, aDelta)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrQueue<T>::TLPtrQueue(T *aPtr)

/*  Constructor that initializes a queue of 1 element.
---------------------------------------------------------------------------*/
: TLVPQueue(aPtr)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrQueue<T>::TLPtrQueue(T **aQueue, size_t aSize)

/*  Constructor that initializes a queue from a corresponding C-style
    vector.
---------------------------------------------------------------------------*/
: TLVPQueue((void **)aQueue, aSize)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrQueue<T>::TLPtrQueue(const TLPtrQueue<T> &aQueue)

/*  Copy constructor.
---------------------------------------------------------------------------*/
: TLVPQueue(aQueue)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrQueue<T>::TLPtrQueue(TLPtrIter<T> &aIter)

/*  Constructor that initializes the queue from an iterator.
---------------------------------------------------------------------------*/
: TLVPQueue(aIter.Count())
{
    SetDelete(DeleteT);
    for (aIter.Reset(); aIter.Next(); )
	Enqueue(aIter.Peek());
}

/*-------------------------------------------------------------------------*/
    template<class T> void TLPtrQueue<T>::DeleteT(void *aPtr)

/*  Deletes pointed to object, after the appropriate typecast.
---------------------------------------------------------------------------*/
{
    delete (T *)aPtr;
}

#endif	// _TLX_PTRQUEUE_CPP
