/****************************************************************************
    $Id: ptrarray.cpp 501.0 1995/03/07 12:26:58 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLPtrArray<T>.

    $Log: ptrarray.cpp $
    Revision 501.0  1995/03/07 12:26:58  RON
    Updated for TLX 5.01
    Revision 1.5  1995/01/31 16:30:44  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.4  1994/09/28  14:41:01  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:27:17  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:31:54  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:15:26  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_PTRARRAY_CPP
#define _TLX_PTRARRAY_CPP

//----- System headers

//----- Project headers

#ifndef _TLX_PTRARRAY_H
#include <tlx\501\ptrarray.h>	// Class declaration
#endif

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrArray<T>::TLPtrArray(size_t aSize)

/*  Constructor to create array of specified size; also doubles as default
    constructor.
---------------------------------------------------------------------------*/
: TLVPArray(aSize)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrArray<T>::TLPtrArray(index_t aFrom, index_t aTo)

/*  Constructor to create array with specified index limits.
---------------------------------------------------------------------------*/
: TLVPArray(aFrom, aTo)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrArray<T>::TLPtrArray(T *aPtr)

/*  Constructor that initializes an array of 1 element.
---------------------------------------------------------------------------*/
: TLVPArray(aPtr)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrArray<T>::TLPtrArray(T **aArray, size_t aSize)

/*  Constructor that initializes an array from a corresponding C-style
    array.
---------------------------------------------------------------------------*/
: TLVPArray((void **)aArray, aSize)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> TLPtrArray<T>::TLPtrArray(const TLPtrArray<T> &aArray)

/*  Copy constructor.
---------------------------------------------------------------------------*/
: TLVPArray(aArray)
{
    SetDelete(DeleteT);
}

/*-------------------------------------------------------------------------*/
    template<class T> void TLPtrArray<T>::DeleteT(void *aPtr)

/*  Deletes pointed to object, after the appropriate typecast.
---------------------------------------------------------------------------*/
{
    delete (T *)aPtr;
}

#endif	// _TLX_PTRARRAY_CPP
