/****************************************************************************
    $Id: pointer.cpp 501.0 1995/03/07 12:26:58 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLCountedPtr<T>.

    $Log: pointer.cpp $
    Revision 501.0  1995/03/07 12:26:58  RON
    Updated for TLX 5.01
    Revision 1.6  1995/01/31 16:30:44  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.5  1994/09/28  14:40:53  ron
    Removed Macintosh-style #include references

    Revision 1.4  1994/09/27  20:27:16  ron
    Changed path separator from / to \

    Revision 1.3  1994/09/26  15:31:35  ron
    Renamed TLPointer<T> to TLCountedPtr<T>

    Revision 1.2  1994/09/06  14:15:50  ron
    Adapted to change from TLRef to TLRefCount

    Revision 1.1  1994/08/16  18:15:26  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_POINTER_CPP
#define _TLX_POINTER_CPP

//----- Project headers

#ifndef _TLX_REFPTR_H
#include <tlx\501\refcnt.h>
#endif

/*-------------------------------------------------------------------------*/
    template<class T> TLCountedPtr<T>::TLCountedPtr()

/*  Default constructor. Relies on the default constructor inherited
    from class TLRefPtr. We need to provide it, though, because the
    compiler will not generate a default constructor in the presence
    of other explicitly declared constructors.
---------------------------------------------------------------------------*/
: TLRefPtr()	// Superfluous really
{
}

/*-------------------------------------------------------------------------*/
    template<class T> TLCountedPtr<T>::TLCountedPtr(T *aPtr)

/*  Constructor that provides conversion from ordinary T pointers.
---------------------------------------------------------------------------*/
: TLRefPtr(aPtr)
{
}

#endif	// _TLX_POINTER_CPP
