/****************************************************************************
    $Id: itemiter.cpp 501.0 1995/03/07 12:26:58 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of item pseudo-iterator templates:

    - TLItemIter
    - TLItemIterConst

    $Log: itemiter.cpp $
    Revision 501.0  1995/03/07 12:26:58  RON
    Updated for TLX 5.01
    Revision 1.4  1995/01/31 16:30:44  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.3  1994/10/06  17:50:44  ron
    Changed #defined name

    Revision 1.2  1994/09/27  20:27:14  ron
    Changed path separator from / to \

    Revision 1.1  1994/09/26  15:31:16  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_ITEMITER_CPP
#define _TLX_ITEMITER_CPP

#ifndef _TLX_VALITER_CPP
#include <tlx\501\template\valiter.cpp>
#endif

/*-------------------------------------------------------------------------*/
    template<class T> TLItemIter<T>::TLItemIter(T &aItem)

/*  Constructor. Links to the given item.
---------------------------------------------------------------------------*/
: mItem(aItem)
{
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLItemIter<T>::FirstPos()

/*  Sets the iterator to the first available position (if any), returning
    true if that move succeeds.
---------------------------------------------------------------------------*/
{
    return true;
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLItemIter<T>::NextPos()

/*  Advances the iterator to the next available position (if any), returning
    true if that move succeeds.
---------------------------------------------------------------------------*/
{
    return false;
}

/*-------------------------------------------------------------------------*/
    template<class T> T &TLItemIter<T>::Peek() const

/*  Returns a reference to the currently iterated element.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(IsValid());
    return mItem;
}

/*-------------------------------------------------------------------------*/
    template<class T> TLItemIterConst<T>::TLItemIterConst(const T &aItem)

/*  Constructor. Links to the given item.
---------------------------------------------------------------------------*/
: mItem(aItem)
{
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLItemIterConst<T>::FirstPos()

/*  Sets the iterator to the first available position (if any), returning
    true if that move succeeds.
---------------------------------------------------------------------------*/
{
    return true;
}

/*-------------------------------------------------------------------------*/
    template<class T> bool TLItemIterConst<T>::NextPos()

/*  Advances the iterator to the next available position (if any), returning
    true if that move succeeds.
---------------------------------------------------------------------------*/
{
    return false;
}

/*-------------------------------------------------------------------------*/
    template<class T> const T &TLItemIterConst<T>::Peek() const

/*  Returns a reference to the currently iterated element.
---------------------------------------------------------------------------*/
{
    TLX_ASSERT(IsValid());
    return mItem;
}

#endif	// _TLX_ITEMITER_CPP
