/****************************************************************************
    $Id: diction.cpp 501.0 1995/03/07 12:26:56 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLDictionary<K,V>.

    $Log: diction.cpp $
    Revision 501.0  1995/03/07 12:26:56  RON
    Updated for TLX 5.01
    Revision 1.2  1995/01/31 16:30:42  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.1  1994/10/12  10:10:07  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_DICTION_CPP
#define _TLX_DICTION_CPP

#ifndef _TLX_ASSOC_H
#include <tlx\501\assoc.h>
#endif

#ifndef _TLX_VALITER_CPP
#include <tlx\501\template\valiter.cpp>
#endif

//-----	TLDictionary<K,V>

template<class K, class V>
TLDictionary<K,V>::TLDictionary(size_t size, size_t delta)
    : mKeys(size, delta), mValues(size, delta) {}

template<class K, class V> size_t TLDictionary<K,V>::Count() const
    { return mKeys.Count(); }

template<class K, class V> bool TLDictionary<K,V>::Contains(const K &key) const
    { return mKeys.Contains(key); }

template<class K, class V>
void TLDictionary<K,V>::Insert(const K &key, const V &value)
    { mKeys.Append(key); mValues.Append(value); }

template<class K, class V> void TLDictionary<K,V>::RemoveAll()
    { mKeys.RemoveAll(); mValues.RemoveAll(); }

template<class K, class V> V &TLDictionary<K,V>::operator [](const K &key)
    { return mValues[mKeys.IndexOf(key)]; }

template<class K, class V>
const V &TLDictionary<K,V>::operator [](const K &k) const
    { return mValues[mKeys.IndexOf(k)]; }

//-----	TLDictIter<K,V>

template<class K, class V>
TLDictIter<K,V>::TLDictIter(TLDictionary<K,V> &aDict)
    : mDict(aDict) { mPos = 0; }

template<class K, class V> K &TLDictIter<K,V>::PeekKey() const
    { return mDict.mKeys[mPos]; }

template<class K, class V> V &TLDictIter<K,V>::Peek() const
    { return mDict.mValues[mPos]; }

template<class K, class V> size_t TLDictIter<K,V>::Count() const
    { return mDict.Count(); }

template<class K, class V> bool TLDictIter<K,V>::Contains(V &aValue)
    { return mDict.mValues.Contains(aValue); }

template<class K, class V> bool TLDictIter<K,V>::FirstPos()
    { mPos = mDict.mKeys.Mini(); return mPos <= mDict.mKeys.Maxi(); }

template<class K, class V> bool TLDictIter<K,V>::NextPos()
    { return ++mPos <= mDict.mKeys.Maxi(); }

#endif	// _TLX_DICTION_CPP
