/****************************************************************************
    $Id: assoc.cpp 501.0 1995/03/07 12:26:56 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLAssoc<K,V>.

    $Log: assoc.cpp $
    Revision 501.0  1995/03/07 12:26:56  RON
    Updated for TLX 5.01
    Revision 1.5  1995/01/31 16:30:42  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.4  1994/09/28  14:40:15  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:27:07  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:28:49  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:15:23  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_ASSOC_CPP
#define _TLX_ASSOC_CPP

#ifndef _TLX_ASSOC_H
#include <tlx\501\assoc.h>
#endif

//-----	Friend functions

template<class K, class V>
ostream &operator <<(ostream &os, const TLAssoc<K,V> &as)
{
//    return os << "[ " << as.mKey << " | " << as.mValue << " ]";
    return os << "[ | ]";
}

template<class K, class V>
int operator ==(const TLAssoc<K,V> &as1, const TLAssoc<K,V> &as2)
{
    return as1.mKey == as2.mKey;
}

template<class K, class V> int operator ==(const TLAssoc<K,V> &as, const K &k)
{
     return as.mKey == k;
}

template<class K, class V> int operator ==(const K &k, const TLAssoc<K,V> &as)
{
     return as.mKey == k;
}

#endif	// _TLX_ASSOC_CPP
