/****************************************************************************
    $Id: array.cpp 501.0 1995/03/07 12:26:56 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Implementation of class TLArray<T>.

    $Log: array.cpp $
    Revision 501.0  1995/03/07 12:26:56  RON
    Updated for TLX 5.01
    Revision 1.6  1995/01/31 16:30:40  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.5  1994/10/07  17:09:29  ron
    Implemented Array<T>::SetLimits()

    Revision 1.4  1994/09/28  14:40:05  ron
    Removed Macintosh-style #include references

    Revision 1.3  1994/09/27  20:27:06  ron
    Changed path separator from / to \

    Revision 1.2  1994/09/26  15:28:37  ron
    Changed include file references

    Revision 1.1  1994/08/16  18:15:22  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_ARRAY_CPP
#define _TLX_ARRAY_CPP

//----- Project headers

#ifndef _TLX_ARRAYS_H
#include <tlx\501\arrays.h>
#endif
#ifndef _TLX_DEBUG_H
#include <tlx\501\debug.h>
#endif

#ifndef _TLX_VBASE_CPP
#include <tlx\501\template\vbase.cpp>
#endif

/*-------------------------------------------------------------------------*/
    template<class T> TLArray<T>::TLArray(size_t sz)

/*  Constructor, also doubling as the default constructor. Creates a
    0-based array of the specified size.
---------------------------------------------------------------------------*/
: TLVBase<T>(sz)
{
    mLower = 0;
}

/*-------------------------------------------------------------------------*/
    template<class T> TLArray<T>::TLArray(index_t lower, index_t upper)

/*  Constructor creating an array with the given lower and upper index
    bounds.
---------------------------------------------------------------------------*/
: TLVBase<T>((size_t)(lower <= upper ? upper - lower + 1: 0))
{
    mLower = lower;
}

/*-------------------------------------------------------------------------*/
    template<class T> TLArray<T>::TLArray(const T &t)

/*  Constructor creating a 1-element array with index base 0.
---------------------------------------------------------------------------*/
: TLVBase<T>(t)
{
    mLower = 0;
}

/*-------------------------------------------------------------------------*/
    template<class T> TLArray<T>::TLArray(const T *t, size_t sz)

/*  Constructor creating an array from a C-style vector of a given size.
    The resulting array is 0-based.
---------------------------------------------------------------------------*/
: TLVBase<T>(t, sz)
{
    mLower = 0;
}

/*-------------------------------------------------------------------------*/
    template<class T> TLArray<T> &TLArray<T>::operator =(const TLArray<T> &t)

/*  Overloading of assignment operator.
---------------------------------------------------------------------------*/
{
    if (this != &t)
    {
	TLVBase<T>::operator =(t);
	mLower = t.mLower;
    }
    return *this;
}

/*-------------------------------------------------------------------------*/
    template<class T> void TLArray<T>::SetLimits(index_t aLower, index_t aUpper)

/*  Changes the limits of the array.
---------------------------------------------------------------------------*/
{
    SetMini(aLower);
    TLX_ASSERT(aUpper - aLower + 1 >= 0);
    Resize(aUpper - aLower + 1);
}

/*-------------------------------------------------------------------------*/
    template<class T> index_t TLArray<T>::SetMini(index_t base)

/*  Sets index base, returning the previous base.
---------------------------------------------------------------------------*/
{
    index_t low = mLower;
    mLower = base;
    return low;
}

#endif	// _TLX_ARRAY_CPP
