/****************************************************************************
    $Id: symantec.h 501.0 1995/03/07 12:26:46 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:	Tarma Library for C++ V5.0
    Author:	Ron van der Wal

    Symantec-specific declarations of compilation and keyword-like names.

    $Log: symantec.h $
    Revision 501.0  1995/03/07 12:26:46  RON
    Updated for TLX 5.01
    Revision 1.6  1995/01/31 16:32:14  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.5  1995/01/18  18:55:31  ron
    Added support for _GUI preprocessor name

    Revision 1.4  1994/11/16  15:23:27  ron
    Added _CCNAME, _CCVER, and _MODEL definitions

    Revision 1.3  1994/10/06  17:49:51  ron
    Added _NOMUTABLE

    Revision 1.2  1994/09/08  15:54:23  ron
    Moved O/S-specific macros into this file

    Revision 1.1  1994/08/16  18:06:53  ron
    Initial revision

****************************************************************************/

#ifndef _TLX_SYMANTEC_H
#define _TLX_SYMANTEC_H

#ifndef __SC__
#error This file is for Symantec compilations only
#endif

#define _CCNAME		Symantec C++
#define _CCVER		__SC__

#ifdef DLL
    #define _IN_DLL	1
#endif

#if __SC__ < 0x700
    #define _NORTTI	1
    #define _NOEXCEPT	1
#endif
#define _NOBOOL		1
#define _NOMUTABLE	1

#if defined(THINK_C)

    // Make sure that we use 4-byte integers under THINK C for compatibility
    // with Symantec C++. We could do that silently with:
    //
    //	    #pragma option(int_4)
    //
    // but this might be missed by casual users.

    #if !__option(int_4)
    #error THINK C users: compile your code with 4-byte integers
    #endif

#endif

#ifdef OS2			/* Non-segmented platforms */

    #define _Near
    #define _Far
    #define _Huge
    #define _MODEL		Flat

    #define _ExportClass	_export
    #define _ExportFunc		_export
    #define _ExportData		_export

    #define _ImportClass
    #define _ImportFunc
    #define _ImportData

    #define OS_OS2      1
    #define _CPU_I86    1
    #define _LENDIAN    1
    #define _NULL_IS_0  1
    #define _MEM_FLAT   1

#elif defined(macintosh)

    #define _GUI	1

    #define _Near
    #define _Far
    #define _Huge
    #define _MODEL		Flat

    #define _ExportClass
    #define _ExportFunc
    #define _ExportData

    #define _ImportClass
    #define _ImportFunc
    #define _ImportData

    #define OS_MAC      1
    #define _CPU_M68    1               // Might be PowerPC!
    #define _BENDIAN    1
    #define _NULL_IS_0  1
    #define _MEM_FLAT   1

#elif defined(_WIN32)

    #define _Near
    #define _Far
    #define _Huge
    #define _MODEL		Flat

    #define _ExportClass	__export
    #define _ExportFunc		__export
    #define _ExportData		__export

    #define _ImportClass	__import
    #define _ImportFunc         __import
    #define _ImportData		__import

    #define OS_WIN32    1
    #define OS_WINXXX   1
    #define _CPU_I86    1	// Could be different processor
    #define _LENDIAN    1
    #define _NULL_IS_0  1
    #define _MEM_FLAT   1

#else				/* Segmented memory architectures */

    #define _Near		_near
    #define _Far		_far
    #define _Huge		_huge

    #define _ExportClass	_export
    #define _ExportFunc		_export _far
    #define _ExportData		_export _far

    #define _ImportClass	_huge
    #define _ImportFunc		_far
    #define _ImportData		_far

    #if __TINY__ || __SMALL__
	#define _CODE_NEAR	1
	#define _DATA_NEAR	1
    	#define _MODEL		Tiny/Small
    #elif __COMPACT__
	#define _CODE_NEAR	1
	#define _DATA_FAR	1
    	#define _MODEL		Compact
    #elif __MEDIUM__
	#define _CODE_FAR	1
	#define _DATA_NEAR	1
    	#define _MODEL		Medium
    #elif __LARGE__ || __HUGE__
	#define _CODE_FAR	1
	#define _DATA_FAR	1
    	#define _MODEL		Large/Huge
    #endif

    #define _CPU_I86    1
    #define _LENDIAN    1
    #define _NULL_IS_0  1
    #define _MEM_SEG    1

    #if defined(__WINDOWS__)
    	#define OS_WIN16    1
    	#define OS_WINXXX   1
    #else
    	#define OS_DOS      1
    	#define OS_DOSXXX   1
    #endif
#endif

#endif	/* _TLX_SYMANTEC_H */
