/****************************************************************************
    $Id: sunpro.h 501.0 1995/03/07 12:26:46 RON Exp $

    Copyright (c) 1991-95 Tarma Software Research. All rights reserved.

    Project:    Tarma Library for C++ V5.0
    Author:     Ron van der Wal

    Header for SunPro C++ compiler description. Works for Solaris 2.x, both
    Intel and Sparc versions.

    $Log: sunpro.h $
    Revision 501.0  1995/03/07 12:26:46  RON
    Updated for TLX 5.01
    Revision 1.4  1995/02/28 18:11:08  RON
    Update for release 012
    Added partial support for SunPro C++ compiler
    Revision 1.3  1995/02/28 18:10:54  RON
    Back to normal
    Revision 1.2  1995/02/28 18:10:06  RON
    Test of Log keyword
    Revision 1.1  1995/02/28 15:29:10  RON
    Initial revision
****************************************************************************/

#ifndef _TLX_SUNPRO_H
#define _TLX_SUNPRO_H

/*---------------------------------------------------------------------------
    Instructions
    ------------

    This file contains sections for all areas that are compiler-specific.
---------------------------------------------------------------------------*/

#define _CCNAME		SunPro C++ compiler
#define _CCVER		__SUNPRO_CC

// If the compiler supports compilation of DLLs (or shared libraries in
// UNIX parlance), modify the following construct such that _IN_DLL is
// #defined to 1 if the compiler is set up for DLL compilation.

//#ifdef _DLL
//#define _IN_DLL     	1
//#endif

// If there are special keywords used for classes in the compiler's runtime
// library, #define the following:

#define _RTLCLASS		// Used as 'class _RTLCLASS iostream;'

// The following set of preprocessor names is used to allow transition to
// the latest ANSI/ISO C++ standards. If your compiler does *not* support
// a particular feature, #define the appropriate name to 1.
//
// Note: it is assumed that the compiler supports at least templates and
// multiple inheritance, i.e. the cfront 2.1 level.

#define _NORTTI		1	// Runtime type information supported?
//#define _NOEXCEPT	1	// Exception handling supported?
#define _NOBOOL		1	// 'bool' data type supported?
#define _NOMUTABLE	1	// 'mutable' modifier supported?

// The largest set of options concerns memory models and related keywords.
// The first distinction is between flat and segmented memory architectures.
// #define *one* of the following:

//#define _MEM_SEG	1	// If a segmented architecture
#define _MEM_FLAT	1	// If a non-segmented architecture

// To cope with segmented platforms, #define the following pseudo-keywords
// as appropriate. Also, specify the kind of default data and code pointers
// for the model.
//
// The directives for imported and exported data, functions, and classes
// are also usually architecture-related, so provide them as well.

#define _Near
#define _Far
#define _Huge

#define _MODEL		Flat	// Describes the model to TLX (only)

#define _ExportClass
#define _ExportFunc
#define _ExportData

#define _ImportClass
#define _ImportFunc
#define _ImportData

// Describe the target platform by defining one or more of the following:

#ifdef __SVR4
#define OS_SV4      	1	// Unix SVR4.2 platform
#endif
#ifdef __unix
#define OS_UNIX      	1	// Defined on all Unix platforms
#endif

// Target CPU (#define *one* of the following)
// Describe endianity (there are no provisions for mixed-endianity)
// by #defining *one* of the following:

#ifdef __i386
#define _CPU_I86    	1	// On Intel i86 platforms
#define _LENDIAN    	1	// Little endian (LSB at lowest address)
#endif
#ifdef __sparc
#define _CPU_SPARC   	1	// On Sparc platforms
#define _BENDIAN    	1	// Big endian (LSB at highest address)
#endif

// If a NULL pointer is represented as an all-0 bit pattern, define this:

#define _NULL_IS_0  	1

#endif  // _TLX_SUNPRO_H
